#!/bin/bash

set -eux

# Run test cases that can run outside of NaCl.
gcc -Wall -Werror -g -O2 rowhammer_asm.S rowhammer_escape_test.c \
    -o rowhammer_escape_test
./rowhammer_escape_test


sel_ldr=native_client/scons-out/opt-linux-x86-64/staging/sel_ldr

# Run test inside of NaCl.
nacl x86_64-nacl-gcc -Wall -Werror -g -O2 \
    rowhammer_asm.S rowhammer_escape_test.c badcode.S \
    -Inative_client/src/untrusted/nacl \
    -Bnative_client/scons-out/nacl-x86-64/lib \
    -lnacl_sys_private \
    -lnacl_dyncode_private \
    -o rowhammer_escape_nacl
$sel_ldr rowhammer_escape_nacl
