/*
  by Luigi Auriemma
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#define HAVE_REMOTE
#include <pcap.h>
//#include <remote-ext.h>
#include "ether_hdrlen.h"



#define VER         "0.1a"
#define DPLAY8JOIN  "\x7f\x00\x01\x00\xc1\x00\x00\x00"



void packet_handler(u_char *dumpfile, const struct pcap_pkthdr *header, const u_char *pkt_data);
void dump_it(u_char *data, int len);



struct iphdr {
    u_int   ihl:4;
    u_int   version:4;
    u_char  tos;
    u_short tot_len;
    u_short id;
    u_short frag_off;
    u_char  ttl;
    u_char  protocol;
    u_short check;
    u_int   saddr;
    u_int   daddr;
};

struct udphdr {
    u_short source;
    u_short dest;
    u_short len;
    u_short check;
};

int     counter;
char    *filename;



int main(int argc, char *argv[]) {
    char            errbuf[PCAP_ERRBUF_SIZE],
                    source[PCAP_BUF_SIZE];
    pcap_t          *fp;


    setbuf(stdout, NULL);

    fputs("\n"
        "Simple join_file extractor for Directlay 8 Fake Players DoS "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <sniff.ACP> <join_file.d8f>\n"
            "\n"
            " This tool is needed to automatically build the so called join_file to use with\n"
            " my Fake Players DoS for Directplay 8 games.\n"
            " In short, you must:\n"
            " - launch a sniffer (Ethereal is perfect)\n"
            " - launch your Directplay 8 game and join a server\n"
            " - close the game and save the sniffed packets in a .acp file\n"
            " - launch this tool specifying the name of the .acp file and the name of the\n"
            "   file you want to create (it will contain the join UDP data)\n"
            "\n", argv[0]);
        exit(1);
    }

    filename = argv[2];

    if(pcap_createsrcstr(
      source,           // variable that will keep the source string
      PCAP_SRC_FILE,    // we want to open a file
      NULL,             // remote host
      NULL,             // port on the remote host
      argv[1],          // name of the file we want to open
      errbuf)) {        // error buffer
        printf("\nError: %s\n", errbuf);
        exit(1);
    }

    fp = pcap_open(
        source,         // name of the device
        65536,          // portion of the packet to capture
        PCAP_OPENFLAG_PROMISCUOUS,  // promiscuous mode
        1000,           // read timeout
        NULL,           // authentication on the remote machine
        errbuf);        // error buffer
    if(!fp) {
        printf("\nError: %s\n", errbuf);
        exit(1);
    }

    counter = 0;

    pcap_loop(fp, 0, packet_handler, NULL);

    pcap_close(fp);

    if(counter) {
        printf("- %d join packets found\n", counter);
    } else {
        printf("- no join packet found\n");
    }
    return(0);
}



void packet_handler(u_char *dumpfile, const struct pcap_pkthdr *header, const u_char *pkt_data) {
    struct  iphdr   *ip;
    struct  udphdr  *udp;
    int     off,
            len;
    u_char  ans[16],
            *data;

    off = 14 + ether_hdrlen(ntohs(*(u_short *)(pkt_data + 12)));

    ip = (struct iphdr *)(pkt_data + off);

    if(ip->protocol == IPPROTO_UDP) {
        len = header->len -             // full packet length
              off -                     // Ethernet offset
              sizeof(struct iphdr) -    // IP
              sizeof(struct udphdr);    // UDP
        if(len <= 0) return;

        udp  = (struct udhdr *)((u_char *)ip + sizeof(struct iphdr));
        data = (unsigned char *)((unsigned char *)udp + sizeof(struct udphdr));

        if(memcmp(data, DPLAY8JOIN, sizeof(DPLAY8JOIN) - 1)) return;

        printf(
            "- found possible join packet, now I dump it\n"
            "  TARGET port is:   %d\n",
            ntohs(udp->dest));

        if(counter) {
            printf("- do you want to overwrite the previously dumped packet? (y/N)\n");
            fflush(stdin);
            fgets(ans, sizeof(ans), stdin);
            if((ans[0] != 'y') && (ans[0] != 'Y')) {
                printf("- no overwrite, I continue\n");
                return;
            }
        }

        dump_it(data, len);
        counter++;
    }
}



void dump_it(u_char *data, int len) {
    FILE    *fd;

    fd = fopen(filename, "wb");
    if(!fd) {
        perror("\nError");
        exit(1);
    }
    fwrite(data, len, 1, fd);
    fclose(fd);
    printf("  %d bytes dumped\n", len);
}


