/*

ether_hdrlen 0.2
by Luigi Auriemma
e-mail: aluigi@autistici.org
web:    aluigi.org

All the length of the pcap and ethernet types I have found in Ethereal,
Nmap and somewhere else.
Useful for sniffers and for who wants something fast and easy to use
without becoming mad to find the offsets to reach the needed data (like
where the IP header starts).

Quick usage:
  if_offset = pcap_hdrlen(pcap_datalink(fp));   // fp = pcap_t interface
  if(if_offset < 0) exit(1);                    // if offset not available
  ...
  offset = if_offset + ether_hdrlen(ntohs(*(u_short *)(pkt_data + if_offset - 2));

on Linux is also possible to use:
  offset = if_offset + ether_hdrlen(ifr.ifr_hwaddr.sa_family);

*/

int pcap_hdrlen(int type) {
    switch(type) {
        case DLT_EN10MB:        return(14);
        case DLT_LINUX_SLL:     return(16);
        case DLT_IEEE802:       return(22);
        case DLT_RAW:           return(0);
        case DLT_NULL:
        case DLT_LOOP:          return(4);
        case DLT_PPP:
        case DLT_PPP_BSDOS:
        case DLT_PPP_SERIAL:
        case DLT_PPP_ETHER:
#if (FREEBSD || OPENBSD || NETBSD || BSDI || MACOSX)
            return(4);
#endif
#ifdef SOLARIS
            return(8)
#else
            return(24);
#endif
        case DLT_ENC:           return(12);
        case DLT_SLIP:
        case DLT_SLIP_BSDOS:
#if (FREEBSD || OPENBSD || NETBSD || BSDI || MACOSX)
            return(16);
#else
            return(24);
#endif
        case DLT_FDDI:          return(21);
        case DLT_ATM_RFC1483:
        case DLT_ATM_CLIP:      return(8);
        default:                return(-1);
    }
}



int ether_hdrlen(unsigned short type) {
    switch(type) {
        case 0x0004:                /* 802.2 frames                 */
        case 0x0005:                /* Internal only                */
        case 0x0006:                /* DEC DDCMP: Internal only     */
        case 0x0007:                /* Dummy type for WAN PPP frames*/
        case 0x0008:                /* Dummy type for PPP MP frames */
        case 0x0009:                /* Localtalk pseudo type        */
        case 0x0010:                /* Dummy type for Atalk over PPP*/
        case 0x0011:                /* 802.2 frames                 */
        case 0x0015:                /* Mobitex (kaz@cafe.net)       */
        case 0x0016:                /* Card specific control frames */
        case 0x0017:                /* Linux-IrDA                   */
        case 0x0018:                /* Acorn Econet                 */
        case 0x0060:                /* Ethernet Loopback packet     */
        case 0x0200:                /* Xerox PUP packet             */
        case 0x0201: return(4);     /* Xerox PUP Addr Trans packet  */
        case 0x0bad: return(18);    /* ETHERTYPE_VINES_IP           */
        case 0x2001: return(4);     /* ETHERTYPE_CGMP               */
        case 0x6000: return(2);     /* DEC Assigned proto           */
        case 0x6558: return(30);    /* ETHERTYPE_ETHBRIDGE          */
        case 0x8035: return(8);     /* ETHERTYPE_REVARP             */
        case 0x8038: return(27);    /* ETHERTYPE_LANBRIDGE          */
        case 0x809B: return(13);    /* Appletalk DDP                */
        case 0x80D5: return(3);     /* ETHERTYPE_SNA                */
        case 0x80F3: return(8);     /* ETHERTYPE_AARP               */
        case 0x80FF: return(2);     /* ETHERTYPE_WCP                */
        case 0x8100: return(4);     /* ETHERTYPE_VLAN               */
        case 0x8137: return(30);    /* IPX over DIX                 */
        case 0x8847: return(18);    /* ETHERTYPE_MPLS               */
        case 0x8863: return(10);    /* PPPoE discovery messages     */
        case 0x8864: return(8);     /* PPPoE session messages       */
        case 0x886D: return(16);    /* ETHERTYPE_INTEL_ANS          */
        case 0x888E: return(4);     /* ETHERTYPE_EAPOL              */
        case 0x889A: return(5);     /* ETHERTYPE_HYPERSCSI          */
        case 0x88AE: return(42);    /* ETHERTYPE_BRDWALK            */
        case 0x9021: return(4);     /* ETHERTYPE_RTNET              */
        case 0x9022: return(1);     /* ETHERTYPE_RTCFG              */
        default: return(0);
    }
}

