<?php

require "vendor/autoload.php";

use Symfony\Component\HttpFoundation\Session\Storage\Handler\PdoSessionHandler;

$dsn = 'mysql:host=localhost;dbname=pdo_session_test';

$config = [
	'user' => 'root',
	'pass' => ''
];

$conn = new \PDO($dsn, $config['user'], $config['pass']);
$conn->setAttribute(\PDO::ATTR_ERRMODE,\PDO::ERRMODE_EXCEPTION);

$handler = new PdoSessionHandler(
		$conn,
		[
			'db_table' => 'sessions',
			'db_id_col' => 'id',
			'db_data_col' => 'data',
			'db_expiry_col' => 'expiry',
			'db_time_col' => 'modified',
			'lock_mode' => PdoSessionHandler::LOCK_TRANSACTIONAL
		]
);

try{
	$handler->createTable();
}catch(\Exception $e){
}

session_set_save_handler($handler);
session_name('my-session');
session_start();

$_SESSION['test'] = 1;

echo $_SESSION['test'];
