from idautils import *
from idc import *
from idaapi import *

whitelist = set(['NSString', 'NSArray', 'NSValue', 'NSDictionary', 'NSData', 'NSColor', 'NSURL', 'NSUUID', 'NSNumber'])

superclasses = {'NSObject': None}

def get_classname(classAddr):
    classInfoAddr = Qword(classAddr + 32)
    classNameAddr = Qword(classInfoAddr + 24)
    className = GetString(classNameAddr, -1, ASCSTR_C)
    return className

for seg in Segments():
    name = SegName(seg).split(':')
    # Can also filter out modules that aren't loaded in the target process here
    if len(name) != 2 or not name[1] == '__objc_classlist':
        continue
    print("Looking at " + SegName(seg))
    start = SegStart(seg)
    end = SegEnd(seg)

    for ea in range(start, end, 8):
        classAddr = Qword(ea)
        superClassAddr = Qword(classAddr + 8)
        if superClassAddr == 0:
            # (hopefully) in this case it's NSObject
            continue
        className = get_classname(classAddr)
        superclassName = get_classname(superClassAddr)
        if not className or not superclassName:
            continue
        superclasses[className] = superclassName
        print(className + " -> " + superclassName)

classes = set()
for cls in superclasses.keys():
    current = cls
    while current is not None:
        if current in whitelist:
            print(cls)
            current = cls
            # Emulate logic of -[NSCoder _validateAllowedClass:]
            while current is not None:
                if get_name_ea_simple('-[' + current + ' initWithCoder:]') != 0xffffffffffffffffL:
                    if get_name_ea_simple('+[' + current + ' supportsSecureCoding]') != 0xffffffffffffffffL:
                        # Seems like all implementations of supportsSecureCoding
                        # return true. Otherwise need to check that here as well
                        classes.add(cls)
                    break
                current = superclasses.get(current, None)
            break
        current = superclasses.get(current, None)

#with open('/path/to/classes.txt', 'w') as f:
with open('/usr/local/google/home/saelo/Desktop/classes.txt', 'w') as f:
    for cls in classes:
        classes = []
        current = cls
        while current is not None:
            classes.append(current)
            current = superclasses.get(current, None)
        f.write(' -> '.join(classes) + '\n')
