#!/usr/bin/env python
import SimpleHTTPServer
import SocketServer

class WebDavHandler(SimpleHTTPServer.SimpleHTTPRequestHandler):
    def do_OPTIONS(self):
        self.send_response(200)
        self.send_header('Allow', 'OPTIONS, GET, PROPFIND')
        self.send_header('DAV', '1, 2')
        self.end_headers()
        self.connection.shutdown(1)

    def do_PROPFIND(self):
        self.send_response(207)
        self.send_header('Content-type', 'text/xml')
        self.end_headers()
        self.wfile.write('<?xml version="1.0"?><a:multistatus xmlns:b="urn:uuid:c2f41010-65b3-11d1-a29f-00aa00c14882/" xmlns:c="xml:" xmlns:a="DAV:"><a:response></a:response></a:multistatus>')
        self.connection.shutdown(1)


SocketServer.TCPServer(('0.0.0.0', 80), WebDavHandler).serve_forever()
