// ianbeer
// build: clang -o charset charset.m -g -framework CoreFoundation -framework Foundation

#if 0
iOS/MacOS memory corruption due to bad bounds checking in NSCharacterSet coding for NSKeyedUnarchiver

The dump today has this list of iOS stuff:
https://wikileaks.org/ciav7p1/cms/page_13205587.html

Reading through this sounded interesting:

"""
Buffer Overflow caused by deserialization parsing error in Foundation library 

Sending a crafted NSArchiver object to any process that calls NSArchive unarchive method will result in
a buffer overflow, allowing for ROP.
"""

So I've spent all day going through initWithCoder: implementations looking for heap corruption :)

The unarchiving of NSCharacterSet will call NSCharacterSetCFCharacterSetCreateWithBitmapRepresentation

If we pass a large bitmap we can get to the following call multiple times:

		while (length > 1) {
			annexSet = (CFMutableCharacterSetRef)__CFCSetGetAnnexPlaneCharacterSet(cset, *(bytes++));

Here's that function (from the quite old CF code, but the disassm still matches)

CF_INLINE CFCharacterSetRef __CFCSetGetAnnexPlaneCharacterSet(CFCharacterSetRef cset, int plane) {
    __CFCSetAllocateAnnexForPlane(cset, plane);
    if (!__CFCSetAnnexBitmapGetPlane(cset->_annex->_validEntriesBitmap, plane)) {
        cset->_annex->_nonBMPPlanes[plane - 1] = (CFCharacterSetRef)CFCharacterSetCreateMutable(CFGetAllocator(cset));
        __CFCSetAnnexBitmapSetPlane(cset->_annex->_validEntriesBitmap, plane);
    }
    return cset->_annex->_nonBMPPlanes[plane - 1];
}

note the interesting [plane - 1], however if we just call this with plane = 0 first
 __CFCSetAllocateAnnexForPlane will set the _nonBMPPlanes to NULL rather than allocating it

but if we supply a large enough bitmap such that we can call __CFCSetGetAnnexPlaneCharacterSet twice,
passing 1 the first time and 0 the second time then we can reach:

	cset->_annex->_nonBMPPlanes[plane - 1] = (CFCharacterSetRef)CFCharacterSetCreateMutable(CFGetAllocator(cset));

with plane = 0 leading to writing a pointer to semi-controlled data one qword below the heap allocation _nonBMPPlanes.

This PoC is just a crasher but it looks pretty exploitable.

The wikileaks dump implies that this kind of bug can be exploited both via IPC and as a persistence mechanism where apps
serialize objects to disk. If I come up with a better PoC for one of those avenues I'll attach it later.

(note that the actual PoC object is in the other file (longer_patched.bin)

tested on MacOS 10.12.3 (16D32)
#endif

#import <Foundation/NSKeyedArchiver.h>

int main() {
  for (int i = 0; i < 1000; i++) {
    [NSKeyedUnarchiver unarchiveObjectWithFile:@"./longer_patched.bin"];
  }
  return 0;
}
