import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.*;

class DisplaySfntFont {
  public static void main(String[] args) throws Exception {
    int width = 500, height = 50;

    File font_file = new File(args[0]);
    Font baseFont = Font.createFont(Font.TRUETYPE_FONT, font_file);

    int styles[] = {Font.PLAIN, Font.ITALIC, Font.BOLD};
    int sizes[] = {8, 12, 24, 48, 72};
    for (int i = 0; i < styles.length; i++) {
      for (int j = 0; j < sizes.length; j++) {
        System.out.print("Iteration (" + i + "," + j + ")\n");
        Font font = baseFont.deriveFont(styles[i], sizes[j]);

        BufferedImage bi = new BufferedImage(width, height, BufferedImage.TYPE_INT_ARGB);
        Graphics2D ig2 = bi.createGraphics();
        ig2.setFont(font);
        ig2.setPaint(Color.white);

        StringBuilder tmp = new StringBuilder();
        for (int ch = 0; ch <= 0xffff; ch++) {
          if (font.canDisplay(ch)) {
            tmp.append((char)ch);
          }

          if (tmp.length() > 25) {
            String message = tmp.toString();
            FontMetrics fontMetrics = ig2.getFontMetrics();
            ig2.drawString(message, 0, 20);

            int stringWidth = fontMetrics.stringWidth(message);

            tmp = new StringBuilder();
          }
        }
      }
    }

    System.out.print("Done\n");
  }
}
