#!/bin/sh
#
# Martin Vuagnoux <martin at vuagnoux dot com>

help_usage()
{
echo "[cbcpad] Bound parser for *.stat files: give the # of times/total higher than <bound>"
echo
echo "USAGE :   ./parse_time.sh <stat file> <bound> <sens>"
echo "          <stat file> = file generated by cbcpad"
echo "          <bound>     = limit in [us]."
echo "          <sens>      = if = 1: print values < <bound>"
echo "                        if = 0: print values > <bound>"
echo
echo "OUTPUT:   stdout"
exit 0
}

# test si usage ok
if [ "$1" = "" ] || [ "$2" = "" ] || [ "$3" = "" ]
    then
    help_usage
    exit 0
fi

btSize=`cat $1 |wc -l`
echo "Processing..."
btSize=`expr $btSize + 1`
btBound=0
i=1
while [ "$i" != $btSize ] ; do
    btValue=`cat $1|head -n $i|tail -n 1`
    cond=`expr "$btValue" \> "$2"`
    if [ "$cond" = "1" ] 
	then
	if [ "$3" = "0" ]
	    then
	    echo "$btValue"
	fi
	btBound=`expr $btBound + 1`
    fi
    if [ "$cond" = "0" ] && [ "$3" = "1" ]
	then
	echo "$btValue"
    fi
    i=`expr $i + 1`    
done
btSize=`expr $btSize - 1`
echo "$btBound/$btSize values are higher than $2"
exit 1
