#!/bin/sh
#
# Martin Vuagnoux <martin at vuagnoux dot com>

help_usage()
{
echo "[cbcpad] Time parser for *.stat files"
echo
echo "USAGE :   ./parse_time.sh <stat file>"
echo "OUTPUT:   ./<stat file>.result.txt"
exit 0
}

# test si usage ok
if [ "$1" = "" ]
then
help_usage
exit 0
fi


# 1. save the values in a file with its size
rm ./parse_time.tmp 2> /dev/null
rm ./parse_time.tmp2 2> /dev/null
rm ./$1.result.txt 2> /dev/null
cat $1 |sort > ./parse_time.tmp
ptSize=`cat ./parse_time.tmp|wc -l`
echo "Processing $ptSize values..."

i=1
ptSize=`expr $ptSize + 1`
while [ "$i" != $ptSize ] ; do
    ptValue=`cat ./parse_time.tmp|head -n $i|tail -n 1`
    ptTime=`grep $ptValue ./parse_time.tmp |wc -l`
    echo "$ptTime $ptValue" >> ./parse_time.tmp2
    i=`expr $i + 1`
done
rm ./parse_time.tmp
cat ./parse_time.tmp2 |uniq|sort -r > ./$1.result.txt
rm ./parse_time.tmp2
echo "Done! check $1.result.txt"
exit 1
