/*
 * Omen - Attack of the Vau[02] CBC-PAD flaw with Imap over SSL/TLS
 *
 * Copyright (c) 2003 Martin Vuagnoux <martin@vuagnoux.com>
 *
 * Omen is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2, or (at your option) any later
 * version.
 *
 * Omen is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along
 * with wavemon; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include "conf.h"

char *version_str = "omen::v1.0 Martin Vuagnoux <martin@vuagnoux.com> january.2003";

void help_exit()
{
  printf("%s\n",version_str);
  printf("Usage: omen [-vh] [-l <port>] [-r <host:port>] [-t <threshold>] [-a <type>]\n\n");
  printf("  -l        Local port to listen\n");
  printf("  -r        Remote Addr:port to connect\n");
  printf("  -t        Threshold in microsends. If not declared, automatic OMEN mode\n"); 
  printf("  -a        Type of attack:     0  IMAPoverTLS   (Outlook 6.x - stunnel)\n");
  printf("                                1  APACHEoverTLS (not yet implemented..)\n");
  printf("  -h        This help screen\n");
  printf("  -v        Print version number and exit\n\n");
  exit(0);
}
void version_exit()
{
  printf("%s\n\n", version_str);
  exit(0);
}

/* parse argument and fill conf struct */
void getargs(struct cbcPadConf *conf, int argc, char *argv[])
{
  int arg;
  char tempString[255+6]; /* hostname:port max size */
  char tempPort[5];
  size_t size;
  int position;
  int i;

  if (argc == 1)
    help_exit();

  /* set the default values */
  conf->listenPort = 993;
  conf->type = 0;
  conf->threshold = -1;

  while ((arg = getopt(argc, argv, "l:r:t:a:hv")) >= 0)
    switch (arg) {
    case 'l': conf->listenPort = atoi(optarg);
      break;
      /* try to have a minimum of unsafe code ;^) */
    case 'r': memcpy((void *)tempString, (void *)optarg, 255+6);
      size = strnlen(tempString, 255+6);
      position = 0;
      for(i=0;i<size;i++) {
        if (tempString[i] == ':') {
          position = i;
          break;
        }
      }
      if (position == 0)
        help_exit();
      memcpy((void *)conf->host, (void *)tempString,i);
      memcpy((void *)tempPort, (void *)&tempString[i+1], 5);
      conf->hostPort = atoi(tempPort);

      break;
    case 't': conf->threshold = atoi(optarg);
      break;
    case 'a': conf->type = atoi(optarg);
      break;
    case 'h': help_exit();
      break;
    case 'v': version_exit();
      break;
    default: exit(-1); /* bad argument */
    }
}
