//Unreal Tournament GetInfo (Windows version)
//	by Auriemma Luigi (bugtest at sitoverde.com)

#include <stdio.h>
#include <winsock.h>
#include <string.h>

#define BUFFSIZE	4096
#define PORT	7778
#define INFO	"\\info\\"
#define STATUS	"\\status\\"
#define CHZ	0x5c	//"\"
#define DELAY	200	//200 ms

void error_handle(int err);
void show(unsigned char *buffer, char *header);

int main(int argc, char *argv[]) {
	setbuf(stdout, NULL);
	if(argc < 2) {
		printf("\nUsage: %s <host> [port(default %d)]\n", argv[0], PORT);
		exit(1);
	}

	WSADATA	wsadata;
	unsigned char	buff[BUFFSIZE];
	struct	sockaddr_in peer;
	struct	hostent *hp;
	int	shandle,
		err,
		recvlen;

	WSAStartup(MAKEWORD(2,0), &wsadata);
	if(inet_addr(argv[1]) == INADDR_NONE) {
                hp = gethostbyname(argv[1]);
		if(hp == 0) error_handle(-1);
                else peer.sin_addr = *((struct in_addr *)hp->h_addr);
        }
                else peer.sin_addr.s_addr = inet_addr(argv[1]);
	if(!argv[2]) peer.sin_port = htons(PORT);
		else peer.sin_port = htons(atoi(argv[2]));
	peer.sin_family = PF_INET;
	recvlen = sizeof(peer);

	shandle = socket(PF_INET, SOCK_DGRAM, IPPROTO_UDP);

	memset(buff, 0x00, BUFFSIZE);
	err = sendto(shandle, INFO, sizeof(INFO), 0, (struct sockaddr *)&peer, recvlen);
	error_handle(err);
	err = recvfrom(shandle, buff, BUFFSIZE, 0, (struct sockaddr *)&peer, &recvlen);
	error_handle(err);
	show(buff, "Information");

	sleep(DELAY);

	memset(buff, 0x00, BUFFSIZE);
	err = sendto(shandle, STATUS, sizeof(STATUS), 0, (struct sockaddr *)&peer, recvlen);
	error_handle(err);
	err = recvfrom(shandle, buff, BUFFSIZE, 0, (struct sockaddr *)&peer, &recvlen);
	error_handle(err);
	show(buff, "Status");

        printf("\n");
	closesocket(shandle);
	WSACleanup();
	return(0);
}

void error_handle(int err) {
	char	*error;

	if(err < 0) {
		switch(WSAGetLastError()) {
		case 10004: error = "Interrupted system call"; break;
		case 10009: error = "Bad file number"; break;
		case 10013: error = "Permission denied"; break;
		case 10014: error = "Bad address"; break;
		case 10022: error = "Invalid argument (not bind)"; break;
		case 10024: error = "Too many open files"; break;
		case 10035: error = "Operation would block"; break;
		case 10036: error = "Operation now in progress"; break;
		case 10037: error = "Operation already in progress"; break;
		case 10038: error = "Socket operation on non-socket"; break;
		case 10039: error = "Destination address required"; break;
		case 10040: error = "Message too long"; break;
		case 10041: error = "Protocol wrong type for socket"; break;
		case 10042: error = "Bad protocol option"; break;
		case 10043: error = "Protocol not supported"; break;
		case 10044: error = "Socket type not supported"; break;
		case 10045: error = "Operation not supported on socket"; break;
		case 10046: error = "Protocol family not supported"; break;
		case 10047: error = "Address family not supported by protocol family"; break;
		case 10048: error = "Address already in use"; break;
		case 10049: error = "Can't assign requested address"; break;
		case 10050: error = "Network is down"; break;
		case 10051: error = "Network is unreachable"; break;
		case 10052: error = "Net dropped connection or reset"; break;
		case 10053: error = "Software caused connection abort"; break;
		case 10054: error = "Connection reset by peer"; break;
		case 10055: error = "No buffer space available"; break;
		case 10056: error = "Socket is already connected"; break;
		case 10057: error = "Socket is not connected"; break;
		case 10058: error = "Can't send after socket shutdown"; break;
		case 10059: error = "Too many references, can't splice"; break;
		case 10060: error = "Connection timed out"; break;
		case 10061: error = "Connection refused"; break;
		case 10062: error = "Too many levels of symbolic links"; break;
		case 10063: error = "File name too long"; break;
		case 10064: error = "Host is down"; break;
		case 10065: error = "No Route to Host"; break;
		case 10066: error = "Directory not empty"; break;
		case 10067: error = "Too many processes"; break;
		case 10068: error = "Too many users"; break;
		case 10069: error = "Disc Quota Exceeded"; break;
		case 10070: error = "Stale NFS file handle"; break;
		case 10091: error = "Network SubSystem is unavailable"; break;
		case 10092: error = "WINSOCK DLL Version out of range"; break;
		case 10093: error = "Successful WSASTARTUP not yet performed"; break;
		case 10071: error = "Too many levels of remote in path"; break;
		case 11001: error = "Host not found"; break;
		case 11002: error = "Non-Authoritative Host not found"; break;
		case 11003: error = "Non-Recoverable errors: FORMERR, REFUSED, NOTIMP"; break;
		case 11004: error = "Valid name, no data record of requested type"; break;
		default: error = "Unknown error"; break;
		}
		printf("\nError: %s\n", error);
		exit(1);
	}
}

void show(unsigned char *buff, char *header) {
	int	j = 1;
	printf("\n\n---\n%s\n---", header);
	for(; *buff != '\0'; buff++) {
		if((*buff == CHZ) && (j == 1)) {
			printf("\n");
			j = 0;
			continue;
		}
		if((*buff == CHZ) && (j == 0)) {
			printf(":\t");
			j = 1;
			continue;
		}
		if(*buff != CHZ) printf("%c", *buff);
	}
}

