/**
 * This program reads in the TCP stream format that the Ethereal sniffer
 *     produces and sends the data to an endpoint.
 *
 * This is all quick & dirty: no time for the 1337 code poetry...
 *
 * Licensed under the GNU Public License v2.0!
 *
 *
 * @author    Joe Testa
 *
 * @version:  $Id: EtherealReplay.java,v 1.2 2002/10/20 21:06:06 jdog Exp $
 *
 *
 * Revisions:
 *            $Log: EtherealReplay.java,v $
 *            Revision 1.2  2002/10/20 21:06:06  jdog
 *            =P
 *
 *            Revision 1.1  2002/10/20 21:03:51  jdog
 *            Initial revision
 *
 *
 */


import java.io.*;
import java.net.*;

public class EtherealReplay {

    public static void main( String args[] ) {


        if ( args.length != 2 ) {
            System.err.println(
                    "Usage:  java Etherfake 192.168.x.x port < file.dump" );
            System.exit( 666 );
        }


        Socket socket = null;
        DataOutputStream stream = null;


        System.out.print( "Connecting..." );

        try {
            socket = new Socket( args[ 0 ], Integer.parseInt( args[ 1 ] ) );
            stream = new DataOutputStream( socket.getOutputStream() );
        } catch( Exception e ) {
            System.err.println( "Error: " + e.getMessage() );
            System.exit( 666 );
        }

        System.out.println( "connected." );


        BufferedReader bufferedReader = new BufferedReader(
                new InputStreamReader( System.in ) );

        try {

            String line = bufferedReader.readLine();
            char charOne, charTwo;
            int pos;
            boolean continueFlag = true;
            while( line != null ) {

                if ( line.charAt( 0 ) != ' ' ) {

                    continueFlag = true;
                    pos = 10;

                    // No time to put comments here.
                    for ( int j = 0; ( j < 2 ) && continueFlag;
                            j++, pos = 35 ) {

                        for( int i = 0; ( i < 8 ) && continueFlag;
                                i++, pos += 3 ) {
                            charOne = line.charAt( pos );
                            charTwo = line.charAt( pos + 1 );

                            // Some lines are incomplete, so skip to the next
                            //     one.
                            if ( charOne == ' ' )
                                continueFlag = false;
                            else
                                stream.write( decode( charOne, charTwo ) );


                        }

                    }

                }

                line = bufferedReader.readLine();
            }


            stream.close();  stream = null;
            socket.close();  socket = null;
        } catch( IOException e ) {
            System.err.println( "IOException: " + e.getMessage () );
        }


    }


    // Converts a hex pair into an int.  There are better ways of doing this
    //     (like using Character.getNumericValue()), but I gotta read
    //     Hamlet now 'cuz there's a quiz in my Shakespeare class tomorrow. =\
    public static int decode( char charOne, char charTwo ) {


        int retVal = 0;

        if ( charOne > '9' )
            retVal = ( ( ( charOne - 'a' ) + 10 ) * 16 );
        else
            retVal = ( ( charOne - '0' ) * 16 );


        if ( charTwo > '9' )
            retVal += ( charTwo - 'a' ) + 10;
        else
            retVal += charTwo - '0';


        return retVal;
    }


}  // EtherealReplay
