/*
    Copyright 2008,2009 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl-2.0.txt
*/

#ifndef IP_HDRINCL
    #define IP_HDRINCL  2
#endif

#define IPSZ        sizeof(iph)
#define UDPSZ       sizeof(udph)
#define PSEUDOSZ    sizeof(pseudoh)
#define MAXUDPPCK   1400



u16 in_cksum(u8 *data1, int len1, u8 *data2, int len2) {
    u32     sum;
    int     endian = 1; // big endian
    u16     crc,
            *p,
            *l;

    if(*(char *)&endian) endian = 0;
    sum = 0;

    for(p = (u16 *)data1, l = p + (len1 >> 1); p < l; p++) sum += *p;
    if(len1 & 1) sum += *p & (endian ? 0xff00 : 0xff);

    if(data2 && len2) {
        for(p = (u16 *)data2, l = p + (len2 >> 1); p < l; p++) sum += *p;
        if(len2 & 1) sum += *p & (endian ? 0xff00 : 0xff);
    }

    sum = (sum >> 16) + (sum & 0xffff);
    crc = sum + (sum >> 16);
    if(!endian) crc = (crc >> 8) | (crc << 8);
    return(~crc);
}



int udpspoof(u32 ip_src, u16 port_src, u32 ip_dst, u16 port_dst, u8 *data, int datalen) {
    typedef struct {
        u8      ihl_ver;
        u8      tos;
        u16     tot_len;
        u16     id;
        u16     frag_off;
        u8      ttl;
        u8      protocol;
        u16     check;
        u32     saddr;
        u32     daddr;
    } iph;
    typedef struct {
        u16     source;
        u16     dest;
        u16     len;
        u16     check;
    } udph;
    typedef struct {
        u32     saddr;
        u32     daddr;
        u8      zero;
        u8      protocol;
        u16     len;
    } pseudoh;

    static  int sd  = 0;
    static  const int   on = 1;
    struct  linger  ling = {1,1};
    struct  sockaddr_in peer;
    iph     *ip;
    udph    *udp;
    pseudoh *pseudo;
    int     ret     = -1,
            fraglen;
    u16     fragoff;
    u8      buff[IPSZ + UDPSZ + MAXUDPPCK],
            *xbyte;

    if(!data || (datalen < 0)) goto quit;
    if(sd <= 0) {
        sd = socket(AF_INET, SOCK_RAW, IPPROTO_UDP);
        if(sd < 0) goto quit;
        setsockopt(sd, IPPROTO_IP, IP_HDRINCL, (char *)&on, sizeof(on));
        setsockopt(sd, SOL_SOCKET, SO_LINGER, (char *)&ling, sizeof(ling));
    }

    ip      = (iph *)buff;
    udp     = (udph *)(buff + IPSZ);
    xbyte   = (u8 *)(buff + IPSZ + UDPSZ);
    pseudo  = (pseudoh *)(buff + IPSZ - PSEUDOSZ);

    pseudo->saddr    = ip_src;
    pseudo->daddr    = ip_dst;
    pseudo->zero     = 0;
    pseudo->protocol = IPPROTO_UDP;
    pseudo->len      = htons(UDPSZ + datalen);

    udp->source      = port_src;
    udp->dest        = port_dst;
    udp->check       = 0;
    udp->len         = pseudo->len;
    udp->check       = htons(in_cksum((u8 *)pseudo, PSEUDOSZ + UDPSZ, data, datalen));

    ip->ihl_ver      = (4 << 4) | (sizeof(iph) >> 2);
    ip->tos          = 0;
    ip->tot_len      = htons(IPSZ + UDPSZ + datalen);
    ip->id           = htons(1);
    ip->frag_off     = htons(0);
    ip->ttl          = 128;
    ip->protocol     = IPPROTO_UDP;
    ip->saddr        = ip_src;
    ip->daddr        = ip_dst;

    peer.sin_addr.s_addr = ip_dst;
    peer.sin_port        = port_dst;
    peer.sin_family      = AF_INET;

    if(datalen <= MAXUDPPCK) {  // quick sending (useful for sending 0 bytes packets too)
        memcpy(xbyte, data, datalen);
        ip->check    = 0;
        ip->check    = htons(in_cksum((u8 *)ip, IPSZ, NULL, 0));

        if(sendto(sd, buff, IPSZ + UDPSZ + datalen, 0, (struct sockaddr *)&peer, sizeof(peer))
          < 0) goto quit;
    } else {
        // Windows doesn't seem to support spoofed fragments because it automatically modifies the ip->id field so there is no way, as far as I know, to force our ID
        for(fragoff = 0; fragoff < datalen; fragoff += fraglen) {
            fraglen = datalen - fragoff;
            if(fraglen > MAXUDPPCK) fraglen = MAXUDPPCK;  // enough for any default MTU
            memcpy(xbyte, data + fragoff, fraglen);

            ip->frag_off = htons(fragoff >> 3);
            if((fragoff + fraglen) < datalen) ip->frag_off |= htons(1 << 13);
            ip->check    = 0;
            ip->check    = htons(in_cksum((u8 *)ip, IPSZ, NULL, 0));

            if(sendto(sd, buff, IPSZ + UDPSZ + fraglen, 0, (struct sockaddr *)&peer, sizeof(peer))
              < 0) goto quit;
        }
    }

    ret = 0;
quit:
    return(ret);
}



#undef IPSZ
#undef UDPSZ
#undef PSEUDOSZ
#undef MAXUDPPCK
