/*
 * ccm
 * Lars Kellogg-Stedman <lars@larsshack.org>
 * Ken Raeburn <raeburn@raeburn.org>
 *
 * $Id: output.c,v 1.3 1999/08/31 21:15:48 lars Exp $
 *
 */

#include <stdio.h>
#include <stdarg.h>
#include <output.h>

/*
 * print a message to stderr and exit with an error code
 */
void	exit_err(int errcode, char *fmt, ...)
{
	va_list	va;
	
	va_start(va,fmt);
	vprint_err(fmt,va);
	va_end(va);
	
	exit (errcode);
}

/*
 * print a message to stderr (prefixed with the
 * value of argv[0] if available).
 */
void	print_err(char *fmt,...)
{
	va_list	va;
	va_start(va,fmt);

	vprint_err(fmt,va);

	va_end(va);
}

void	vprint_err(char *fmt,va_list va)
{
	if (exe_name)
		fprintf(stderr,"%s: ",exe_name);
	vfprintf(stderr,fmt,va);
	fputc('\n',stderr);
}

