/*** This program is (C)opyright by Stealth.
 *** You may use it under the terms of the GPL.
 *** So there is ABSOLUTELY NO WARRANTY. You use it at your own risk!
 *** All the sources are provided ''AS IS'' in the hope that
 *** they will be usefull. It's all for educational purposes only!
 *** Neither the author nor the distributor of my programs is responsible
 *** for possible attacks/damages/usage done with this programs or with
 *** the knowledge that such persons gained by reading these sources!!!
 ***/
#define MAXFRAG 8
#define FORCE_OR_NOT 0
#include <stdio.h>
#include <sys/types.h>
#include <utime.h>
#include <sys/stat.h>
#include <string.h>
#include <sys/param.h>
#include <sys/mount.h>

#include <ufs/ufs/dinode.h>
#include <ufs/ufs/dir.h>
#include <ufs/ffs/fs.h>
#include <ufs/ufs/ufsmount.h>

#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include "fsck.h"

#define MAXB 1024*1024

/*** hide a file in an UFS filesystem by getting the inode of a file,
 *** cat the data to that file and rewind the size of the inode to the
 *** original value
 ***/
int ufs_hide_file(const char *datafile, const char *cfile, 
                  const char *mountpoint, const char *fs)
{
        
        struct dinode *dp;
        struct stat st;
	struct  utimbuf ut;
        int d_fd = 0, c_fd = 0, c_size = 0, 
            d_size = 0, new_size = 0, r = 0;
        char buf[10000] = {0};
	
   	memset(buf, 0, 10000);
        memset(&dp, 0, sizeof(struct dinode));
        memset(&st, 0, sizeof(st));

	if (!setup(fs)) {
		perror(fs);
		exit(errno);
	}

        /* find out inode
         */
        if (stat(cfile, &st) < 0) {
           	perror("stat");
                exit(errno);
        }
	ut.actime = st.st_atime;
	ut.modtime = st.st_mtime;
	
#if 1
        /* open later corruptfile 
         */
        if ((c_fd = open(cfile, O_RDWR|O_APPEND)) < 0) {
           	perror("open [cfile]");
                exit(errno);
        }
        /* and the file that contains the data 
         */
        if ((d_fd = open(datafile, O_RDONLY)) < 0) {
           	perror("open [datafile]");
                exit(errno);
        }

        /* save old size 
         */
        c_size = lseek(c_fd, 0, SEEK_END);
        d_size = lseek(d_fd, 0, SEEK_END); lseek(d_fd, 0, SEEK_SET);


	if (d_size > c_size) {
		fprintf(stderr, "Sorry, datafile must be less big than corruptfile\n");
		exit(1);
	}
        
	/* check if small enuff
	 */
	if (d_size > MAXB) {
		printf("Sorry, you can't store more than %d bytes per file.\n", MAXB);
		exit(1);
	}
	
        new_size = c_size;
        /* first 10 bytes of c-file
         * contain the length of the data-file
         */
        sprintf(buf, "%010d", d_size);
        printf("Found size %d on corrupted file %s.\n", c_size, cfile);
        
        /* append data to file 
         */
        write(c_fd, buf, strlen(buf)); 
        while ((r = read(d_fd, buf, 10000)) > 0) {
           	new_size += r;
           	write(c_fd, buf, r);
		memset(buf, 0, sizeof(buf));
        }
        close(c_fd); close(d_fd);
	utime(cfile, &ut);
	sync();
#endif
	printf("Old inode:\n");
	pinode(st.st_ino);
        dp = ginode(st.st_ino);
        dp->di_size = c_size;

	printf("\nNew Inode:\n"); pinode(st.st_ino);
	inodirty();
	
	sblock.fs_clean = 0;
	sbdirty();
	ckfini(1);
	sync();
	
	if (unmount(mountpoint, FORCE_OR_NOT) < 0) {
		perror("unmount");
		exit(errno);
	}
	ufs_hot_remount(mountpoint, fs, 0);
	return 0;       
}
   	
/*** get the data back from that file,
 *** that we have corrupted.
 *** we do this by simply truncate() it to 1Meg bigger
 *** as it already is and read out the gotten data
 ***/
int ufs_fetch_file(const char *datafile, const char* cfile)
{
	int c_fd = 0, d_fd = 0, d_size = 0, r = 0;
	struct stat st;
	struct utimbuf ut;
	char buf[12] = {0};
	char *xbuf = NULL;
	char tmpfile[1000] = {0};
	
	if (stat(cfile, &st) < 0) {
		perror("stat");
		exit(errno);
	}
	ut.actime = st.st_atime;
	ut.modtime = st.st_mtime;
	
	truncate(cfile, st.st_size + 10 + MAXB);
	
	if ((c_fd = open(cfile, O_RDONLY)) < 0) {
		perror("open");
		exit(errno);
	}
	lseek(c_fd, st.st_size, SEEK_SET);
	
	/* the 10 last bytes contain the length of the data
	 */
	read(c_fd, buf, 10);
	sscanf(buf, "%10d", &d_size);
	
	if (d_size > MAXB) {
		printf("Fatal: You hided more data into a file then i can extract!\n"
		       "(How did you do that ???)\n");
		exit(1);
	}
	printf("Extract %d byte on file %s into %s\n", d_size, cfile, datafile);
	
	if ((d_fd = open(datafile, O_RDWR|O_CREAT|O_EXCL, 0600)) < 0) {
		perror("open");
		exit(errno);
	}
	if ((xbuf = (char*)malloc(d_size)) == NULL) {
		perror("malloc");
		exit(errno);
	}
	memset(xbuf, 0, d_size);
	
	/* read out data and write it to new datafile */
	r = read(c_fd, xbuf, d_size);
	write(d_fd, xbuf, r);
	close(c_fd); close(d_fd);
	/* End of fetching datafile */
	
	
	/* and now: restore old file 
	 *
	 */
	/* to avoid cross-device errors */
	snprintf(tmpfile, 1000, "%s%d", cfile, getpid());
	if (rename(cfile, tmpfile) < 0) {
		perror("rename");
		exit(errno);
	}
	if ((c_fd = open(tmpfile, O_RDONLY)) < 0) {
		perror("tmp-open");
		exit(errno);
	}
	if ((d_fd = open(cfile, O_RDWR|O_CREAT)) < 0) {
		perror("open");
		exit(errno);
	}
	if ((xbuf = (char*)realloc(xbuf, st.st_size)) == NULL) {
		perror("realloc");
		exit(errno);
	}
	if ((r = read(c_fd, xbuf, st.st_size)) != st.st_size) {
		perror("read ???");
		exit(errno);
	}
	write(d_fd, xbuf, r);
	close(c_fd); close(d_fd);
	free(xbuf);
	unlink(tmpfile);
	
	/* resore old time */
	utime(cfile, &ut);
	chmod(cfile, st.st_mode);
	
	/* However, a resore by truncate() as in E2-Zip will
	 * cause FreeBSD to hardly crash
	 */
	return 0;
}

/*** Set fileflags to 0 in securelevel 1 mode
 ***/
int ufs_clean_flags(const char *filename, const char *mountpoint, const char *fs)	
{

	struct stat statbuf;
	struct dinode *dp;
	
	memset(&statbuf, 0, sizeof(statbuf));
	if (stat(filename, &statbuf) < 0) {
		perror("stat");
		exit(errno);
	}
	printf("File has the flags: %x (inode#=%d)\n", statbuf.st_flags, statbuf.st_ino);

	if (unmount(mountpoint, FORCE_OR_NOT) < 0) {
		perror("unmount");
		exit(errno);
	}
	if (!setup(fs)) {
		perror(fs);
		exit(errno);
	}
	dp = ginode(statbuf.st_ino);
	
	pinode(statbuf.st_ino);
	dp->di_flags = 0;
	
	inodirty();
	
	sblock.fs_clean = 0;
	sbdirty();
	ckfini(1);
	sync();
	
	ufs_hot_remount(mountpoint, fs, 0);
	
	return 0;
}

int ufs_hot_remount(const char *mountpoint, const char *fs, int is_mounted)
{
#if 1
	struct statfs stfs_buf = {0};
	struct ufs_args args = {0};
	int flags = 0, i = 0;
	char *block_fs;
	
	if ((block_fs = (char*)malloc(strlen(fs))) == NULL) {
		perror("malloc");
		exit(errno);
	}
	memset(block_fs, 0, strlen(fs));
	/* skip 'r' in /dev/rfd0 etc. */
	while (*fs) {
		if (*fs != 'r')
			block_fs[i++] = *fs;
		fs++;
	} 
	printf("Hot remount of %s into %s\n", block_fs, mountpoint);
	if (is_mounted) {
	    /*
	     * Check to see if root is mounted read-write.
	     */
		if (statfs(mountpoint, &stfs_buf) < 0) {
		        perror("statfs");
			exit(errno);
		}
	}
	flags = 0;//stfs_buf.f_flags;
	
	/* man 2 mount */
	args.fspec = block_fs;
	args.export.ex_flags = 0;
	args.export.ex_root = 0;
	if (is_mounted)
		flags |= MNT_UPDATE | MNT_RELOAD;
	flags |= MNT_FORCE;
	if (mount("ufs", mountpoint, flags, &args) < 0) {
		perror("mount");
		exit(errno);
	}
	free(block_fs);
#endif
	return 0;
}
