#include <sys/resource.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>

#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>


int main(int argc, char **argv, char **envp) {
	struct rlimit core_limit;

	if (getrlimit(RLIMIT_CORE, &core_limit) != 0) {
		perror("getrlimit()");
		exit(1);
	}

	if (core_limit.rlim_cur == 0) {
		printf("Please enable core dumps prior executing this program.\n");
		printf("You can do so by executing for example 'ulimit -c 1024'\n");
		exit(1);
	}

	if (argc < 2 || access(argv[1], X_OK)) {
		printf("usage: %s 64bit_prog\n", argv[0]);
		exit(1);
	}

	printf("* look at /proc/%d/maps and press enter to continue...", getpid());
	while (getchar() != '\n')
		;

	printf("* executing %s...\n", argv[1]);
	execve(argv[1], &argv[1], envp);
	printf("* that failed (%s), as expected :)\n", strerror(errno));

	printf("* look at /proc/%d/maps and press enter to continue...", getpid());
	while (getchar() != '\n')
		;

	printf("* fasten your seat belt, generating segmentation fault...\n");
	*(char *) 0x4711 = 'A';

	return 0;
}
