#include <bootstrap.h>
#include <bsm/libbsm.h>
#include <CoreFoundation/CoreFoundation.h>
#include <os/log.h>
#include <Security/Security.h>
#include <stdio.h>
#include <stdlib.h>

#define MAX_MSG_SIZE (8 * 1024 - MAX_TRAILER_SIZE)

typedef boolean_t (*dispatch_mig_callback_t)(mach_msg_header_t *message,
		mach_msg_header_t *reply);
mach_msg_return_t dispatch_mig_server(dispatch_source_t ds, size_t maxmsgsz, dispatch_mig_callback_t callback);

boolean_t entitlementChecker_server
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP);

kern_return_t check_entitlements(mach_port_t server, audit_token_t token)
{
    // Simulate race here...
    puts("Message received. Press <enter> to continue...");
    getchar();

    SecTaskRef task = SecTaskCreateWithAuditToken(kCFAllocatorDefault, token);
	CFStringRef entitlement = CFSTR("com.apple.private.AuthorizationServices");
    CFTypeRef value = SecTaskCopyValueForEntitlement(task, entitlement, NULL);

	CFStringRef description = CFCopyDescription(value);

    puts("Value of entitlement \"com.apple.private.AuthorizationServices\":");
	puts(CFStringGetCStringPtr(description, kCFStringEncodingASCII));

    return KERN_SUCCESS;
}

int main(int argc, const char *argv[]) {
    puts("net.saelo.entitlementchecker starting");

    mach_port_t bootstrap_port, service_port;
    task_get_special_port(mach_task_self(), TASK_BOOTSTRAP_PORT, &bootstrap_port);

    kern_return_t kr = bootstrap_check_in(bootstrap_port, "net.saelo.entitlementchecker", &service_port);
    dispatch_source_t source = dispatch_source_create(DISPATCH_SOURCE_TYPE_MACH_RECV, service_port, 0, dispatch_get_main_queue());

    dispatch_source_set_event_handler(source, ^{
        dispatch_mig_server(source, MAX_MSG_SIZE, entitlementChecker_server);
    });

    dispatch_resume(source);

    dispatch_main();
    exit(EXIT_FAILURE);
}
