/* 
 *	Multi-Purpose Modification Tool
 */

#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <getopt.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>

/* defines */

#define VERSION "0.6"

/* prototypes */

void usage(char *name);

/* functions */

void usage(char *name)
{
	fprintf(stderr, "Multi-Purpose Modification Tool v%s by Andrew Griffiths\n", VERSION);

	fprintf(stderr, "%s -1 [ -2 ] [ -o ] [ -p | -f | -s ] [ -r ]\n\n", name);

	fprintf(stderr, "%s -o 0xa020ee1f -p -1 61\n", name);
	fprintf(stderr, "\tWould print out the offset of chroot at the sys_call_table\n\tlocation of 0xa020ee1f\n\n");

	fprintf(stderr, "%s -1 23 -2 36\n", name);
	fprintf(stderr, "\tWould replace setuid()'s location in sys_call_table with\n\tsync()s function.\n\n");

	fprintf(stderr, "%s -1 23 -2 36 -r\n", name);
	fprintf(stderr, "\tWould replace setuid()'s location in sys_call_table with\n\tsync()s function, and restore it back to it would in n\n\tseconds. (time default is 30 seconds)\n\n");

	fprintf(stderr, "For values of these numbers, look in /usr/include/asm/unistd.h\n\n");	

	fprintf(stderr, "Also, you can do abiratory read and writes on kernel memory,\n");
	fprintf(stderr, "with the -a for the address, -c for how much to copy, -R to\n");
	fprintf(stderr, "read, and -W to write and -F to specify file.\n");

	exit(EXIT_FAILURE);
}

int main(int argc, char *argv[])
{
	unsigned long saved, **sys_call_table = (unsigned long) 0xa019f650;
	unsigned long *addr=NULL;
	int offset1=0, offset2=0, time=30, fd;
	char c, *name="mpmt.mem_dump";
	int print=0, restore=0, forkbg=0, shell=0, copy=0;
	int readf=0, writef=0;
	extern char *optarg;

	if(argv > 1) if(strncmp(argv[1], "-advice", 7)==0) {
		printf("Don't Panic!\n");
		exit(42);
	}

	while((c = getopt(argc, argv, "o:1:2:fprts:a:c:F:RW")) != -1) {
		switch(c) {
		case 'o':
			sys_call_table = (unsigned long) strtoul(optarg, NULL, 16);
			break;
		case '1':
			offset1 = strtod(optarg, NULL);
			break;
		case '2':
			offset2 = strtod(optarg, NULL);
			break;
		case 'f':
			forkbg = 1;
			break;
		case 'p':
			print=1;
			break;
		case 'r':
			restore=1;
			break;
		case 's': 
			shell=1;
			break;
		case 't':
			time = strtod(optarg, NULL);
			break;
		case 'a':
			addr = strtoul(optarg, NULL, 16);
			break;
		case 'c':
			copy = strtod(optarg, NULL);
			break;
		case 'F':
			name = strdup(optarg);
			break;
		case 'R':
			readf = 1;
			break;
		case 'W':
			writef = 1;
			break;
		}
	}

	if(addr == NULL) { 
		if(print == 0) if(offset1 == 0 || offset2==0) usage(argv[0]);
		if(forkbg && shell) usage(argv[0]);

		if(print) {
			printf("Location in memory where function %d is %p\n", offset1, sys_call_table[offset1]);
			exit(EXIT_SUCCESS);
		}

		if(forkbg) {
			if(fork()) exit(EXIT_SUCCESS); 
			close(0); close(1); close(2);
			setsid();
		}

		if(restore) saved = sys_call_table[offset1];
	
		sys_call_table[offset1] = sys_call_table[2];

		if(shell) system("/bin/bash");

		if(restore) {
			sleep(time); 
			sys_call_table[offset1] = saved;
		}
	} else if(addr != NULL && readf != 0) { /* addr != NULL */
		fd = open(name, O_WRONLY|O_CREAT|O_TRUNC);
		if(fd < 0) {
			printf("Can't open %s: %s\n", name, strerror(errno));
			exit(EXIT_FAILURE);
		}

		if(write(fd, addr, copy)!=copy) {
			printf("Failed to write everything, %s\n", strerror(errno));
			exit(EXIT_FAILURE);
		}

		close(fd);
		writef = 0;
	} else if(addr != NULL && writef != 0) {
		fd = open(name, O_RDONLY);
		if(fd < 0) {
			printf("Can't open %s: %s\n", name, strerror(errno));
			exit(EXIT_FAILURE);
		}

		if(read(fd, addr, copy)!=copy) {
			printf("Failed to read everything, %s\n", strerror(errno));
			exit(EXIT_FAILURE);
		}
		close(fd);
	}
}
