#include <stdio.h>

#include "SkCanvas.h"
#include "SkPath.h"
#include "SkBitmap.h"

int main(int argc, char * const argv[]) {
  SkBitmap bitmap;
  bitmap.allocN32Pixels(24, 24);
  SkCanvas canvas(bitmap);

  SkPaint paint;
  paint.setAntiAlias(true);
  paint.setStyle(SkPaint::kFill_Style);

  SkPoint points[12];
  points[0] = {0, 2};
  points[1] = {0, 1};
  points[2] = {1, 0};
  points[3] = {2, 0};
  points[4] = {3, 23.5};
  points[5] = {23, 24};
  points[6] = {24, 24};
  points[7] = {4, 23.5};
  points[8] = {3, 0};
  points[9] = {2, 0};
  points[10] = {1, 1};
  points[11] = {1, 2};

  for(int i=0;i<12;i++) {
    points[i].fY = points[i].fY * 1e-30;
  }

  for(int i=0;i<12;i++) {
    points[i].fY = points[i].fY + points[i].fX * 1e-28;
  }

  SkPath path;
  path.moveTo(points[0]);
  for(int i=1; i<12;i++) {
    path.lineTo(points[i]);
  }
  path.close();
  
  if(path.isConvex()) {
    printf("convex\n");
  } else {
    printf("not convex\n");
  }

  SkMatrix m;
  m.setSkew(0, -1e-28);
  m.postScale(1, 1e30);
  path.transform(m);

  if(path.isConvex()) {
    printf("convex\n");
  } else {
    printf("not convex\n");
  }

  canvas.drawPath(path, paint);

  printf("done\n");

  return 0;  
}

