#include <stdlib.h>
#include <string.h>
#include "getput.h"
#include "md5.h"
#include "gmp.h"

extern void fatal (char*, ...);

void mp_linearize_msb_first(unsigned char *buf, unsigned int len, MP_INT *value)
{
  unsigned int i;
  MP_INT aux;
  mpz_init_set(&aux, value);
  for (i = len; i >= 4; i -= 4)
    {
      unsigned long limb = mpz_get_ui(&aux);
      PUT_32BIT(buf + i - 4, limb);
      mpz_div_2exp(&aux, &aux, 32);
    }
  for (; i > 0; i--)
    {
      buf[i - 1] = mpz_get_ui(&aux);
      mpz_div_2exp(&aux, &aux, 8);
    }
  mpz_clear(&aux);
}

/* Extract a multiple-precision integer from buffer.  The value is stored
   in the buffer msb first. */

void mp_unlinearize_msb_first(MP_INT *value, const unsigned char *buf,
                              unsigned int len)
{
  unsigned int i;
  mpz_set_ui(value, 0);
  for (i = 0; i + 4 <= len; i += 4)
    {
      unsigned long limb = GET_32BIT(buf + i);
      mpz_mul_2exp(value, value, 32);
      mpz_add_ui(value, value, limb);
    }
  for (; i < len; i++)
    {
      mpz_mul_2exp(value, value, 8);
      mpz_add_ui(value, value, buf[i]);
    }
}

/* Computes a 16-byte session id in the global variable session_id.
   The session id is computed by concatenating the linearized, msb
   first representations of host_key_n, session_key_n, and the cookie. */

void compute_session_id(unsigned char session_id[16],
                        unsigned char cookie[8],
                        unsigned int host_key_bits,
                        MP_INT *host_key_n,
                        unsigned int session_key_bits,
                        MP_INT *session_key_n)
{
  unsigned int bytes = (host_key_bits + 7) / 8 + (session_key_bits + 7) / 8 + 8;
  unsigned char *buf;
  struct MD5Context md;
  
  
  buf = malloc(bytes);
  if (buf == NULL) fatal("compute session_id: malloc");
  
  
  mp_linearize_msb_first(buf, (host_key_bits + 7 ) / 8, host_key_n);
  mp_linearize_msb_first(buf + (host_key_bits + 7 ) / 8, 
                         (session_key_bits + 7) / 8, session_key_n);
  memcpy(buf + (host_key_bits + 7) / 8 + (session_key_bits + 7) / 8,
         cookie, 8);
  MD5Init(&md);
  MD5Update(&md, buf, bytes);
  MD5Final(session_id, &md);
  free(buf);
}
