
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <resolv.h>



extern void fatal(char *, ...);


int
uuencode(u_char *src, u_int srclength, char *target, size_t targsize)
{
	return __b64_ntop(src, srclength, target, targsize);
}

int
uudecode(const char *src, u_char *target, size_t targsize)
{
	int len;
	char *encoded, *p;

	/* copy the 'readonly' source */
	encoded = strdup(src);
	if (encoded == NULL) fatal("uudecode strdup facka");
	
	/* skip whitespace and data */
	for (p = encoded; *p == ' ' || *p == '\t'; p++);
	for (; *p != '\0' && *p != ' ' && *p != '\t'; p++);
	
	/* and remote trailing whitespace because __b64_pton needs this */
	*p = '\0';
	len = __b64_pton(encoded, target, targsize);
	free(encoded);
	return len;
}

void
dump_base64(FILE *fp, u_char *data, int len)
{
	u_char *buf;
	int i, n;

	buf = malloc(2*len);
	if (buf == NULL) fatal("dump_base64 malloc fucka");
	
	n = uuencode(data, len, buf, 2*len);
	for (i = 0; i < n; i++) {
		fprintf(fp, "%c", buf[i]);
		if (i % 70 == 69)
			fprintf(fp, "\n");
	}
	if (i % 70 != 69)
		fprintf(fp, "\n");
	free(buf);
}

